/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.dom.TypeExpression;
import org.eclipse.epsilon.eol.dom.TypeInitialiser;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.types.EolType;

public class NewInstanceExpression
extends TypeInitialiser {
    protected TypeExpression typeExpression;
    protected List<Expression> parameterExpressions = new ArrayList<Expression>();

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.typeExpression = (TypeExpression)module.createAst(cst.getFirstChild(), (ModuleElement)this);
        if (cst.getChildCount() == 2) {
            for (AST parameterAst : cst.getSecondChild().getChildren()) {
                this.parameterExpressions.add((Expression)module.createAst(parameterAst, (ModuleElement)this));
            }
        }
    }

    @Override
    public Object execute(IEolContext context) throws EolRuntimeException {
        Object result = context.getExecutorFactory().execute(this.typeExpression, context);
        if (!(result instanceof EolType)) {
            throw new EolRuntimeException("Expected type, found " + result, this.typeExpression);
        }
        return this.initialiseType((EolType)result, this.parameterExpressions, context, true);
    }

    public TypeExpression getTypeExpression() {
        return this.typeExpression;
    }

    public void setTypeExpression(TypeExpression typeExpression) {
        this.typeExpression = typeExpression;
    }

    public List<Expression> getParameterExpressions() {
        return this.parameterExpressions;
    }

    @Override
    public void accept(IEolVisitor visitor) {
        visitor.visit(this);
    }
}

