/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.dom.TypeExpression;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.EolTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.EolUndefinedVariableException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelNotFoundException;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.types.EolModelElementType;
import org.eclipse.epsilon.eol.types.EolType;

public class NameExpression
extends Expression {
    protected String name;
    protected boolean isTypeName = false;

    public NameExpression() {
    }

    public NameExpression(String name) {
        this.name = name;
    }

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.name = cst.getText();
    }

    public Object execute(IEolContext context, boolean returnVariable) throws EolRuntimeException {
        FrameStack scope = context.getFrameStack();
        Variable variable = scope.get(this.name);
        if (variable != null && variable.getDeprecationInfo() != null) {
            context.getWarningStream().println("Warning: " + variable.getDeprecationInfo());
        }
        if (variable == null && this.name.contains("!")) {
            variable = this.getModelElementType(this.name, context);
        }
        if (variable == null) {
            try {
                IModel model = context.getModelRepository().getModelByName(this.name);
                if (model != null) {
                    variable = Variable.createReadOnlyVariable(this.name, model);
                }
            }
            catch (EolModelNotFoundException model) {
                // empty catch block
            }
        }
        if (variable == null) {
            try {
                EolType type = new TypeExpression(this.name).execute(context);
                if (type != null) {
                    variable = Variable.createReadOnlyVariable(type.getName(), type);
                }
            }
            catch (EolTypeNotFoundException eolTypeNotFoundException) {
                // empty catch block
            }
        }
        if (variable == null) {
            throw new EolUndefinedVariableException(this.name, this);
        }
        if (returnVariable) {
            return variable;
        }
        return variable.getValue();
    }

    @Override
    public Object execute(IEolContext context) throws EolRuntimeException {
        return this.execute(context, false);
    }

    public Variable getModelElementType(String name, IEolContext context) {
        try {
            return Variable.createReadOnlyVariable(name, new EolModelElementType(name, context));
        }
        catch (EolRuntimeException rex) {
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isTypeName() {
        return this.isTypeName;
    }

    public void setTypeName(boolean isTypeName) {
        this.isTypeName = isTypeName;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + ": name=" + this.name + ", isTypeName=" + this.isTypeName;
    }

    @Override
    public void accept(IEolVisitor visitor) {
        visitor.visit(this);
    }
}

