/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import java.util.Collection;
import java.util.Map;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.ExecutorFactory;
import org.eclipse.epsilon.eol.execute.context.IEolContext;

public class ItemSelectorExpression
extends Expression {
    protected Expression targetExpression;
    protected Expression indexExpression;

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.targetExpression = (Expression)module.createAst(cst.getFirstChild(), (ModuleElement)module);
        this.indexExpression = (Expression)module.createAst(cst.getSecondChild(), (ModuleElement)module);
    }

    @Override
    public Object execute(IEolContext context) throws EolRuntimeException {
        ExecutorFactory executorFactory = context.getExecutorFactory();
        Object expression = executorFactory.execute(this.targetExpression, context);
        Object index = executorFactory.execute(this.indexExpression, context);
        if (expression instanceof Collection) {
            if (!(index instanceof Integer)) {
                throw new EolRuntimeException("Collection index must be an integer but " + index + " was provided instead.", this.indexExpression);
            }
            return CollectionUtil.asList((Object)expression).get((Integer)index);
        }
        if (expression instanceof Map) {
            return ((Map)expression).get(index);
        }
        throw new EolRuntimeException(expression + " is not a collection or a map.", this.targetExpression);
    }

    public Expression getTargetExpression() {
        return this.targetExpression;
    }

    public void setTargetExpression(Expression targetExpression) {
        this.targetExpression = targetExpression;
    }

    public Expression getIndexExpression() {
        return this.indexExpression;
    }

    public void setIndexExpression(Expression indexExpression) {
        this.indexExpression = indexExpression;
    }

    @Override
    public void accept(IEolVisitor visitor) {
        visitor.visit(this);
    }
}

