/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.util.StringUtil;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.FeatureCallExpression;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.dom.NameExpression;
import org.eclipse.epsilon.eol.dom.Parameter;
import org.eclipse.epsilon.eol.exceptions.EolIllegalOperationException;
import org.eclipse.epsilon.eol.exceptions.EolNullPointerException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.operations.AbstractOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.CollectBasedOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.CollectOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.DelegateBasedOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.FirstOrderOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.SelectBasedOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.SelectOperation;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.types.EolModelElementType;
import org.eclipse.epsilon.eol.types.EolNoType;
import org.eclipse.epsilon.eol.types.EolType;

public class FirstOrderOperationCallExpression
extends FeatureCallExpression {
    protected List<Parameter> parameters = new ArrayList<Parameter>(2);
    protected List<Expression> expressions = new ArrayList<Expression>(3);

    public FirstOrderOperationCallExpression() {
    }

    public FirstOrderOperationCallExpression(Expression targetExpression, NameExpression nameExpression, Parameter parameter, Expression lambdaExpression) {
        this.targetExpression = targetExpression;
        this.nameExpression = nameExpression;
        this.parameters.add(parameter);
        this.expressions.add(lambdaExpression);
    }

    @Override
    public void build(AST cst, IModule module) {
        AST lambdaParamsContainer;
        AST exprAst;
        super.build(cst, module);
        if (cst.getType() != 23 && cst.getFirstChild().getType() != 29) {
            this.targetExpression = (Expression)module.createAst(cst.getFirstChild(), (ModuleElement)this);
            exprAst = cst.getSecondChild();
            this.nameExpression = (NameExpression)module.createAst(exprAst, (ModuleElement)this);
        } else {
            this.nameExpression = new NameExpression(cst.getText());
            this.nameExpression.setRegion(cst.getRegion());
            this.nameExpression.setUri(cst.getUri());
            this.nameExpression.setModule(cst.getModule());
            exprAst = cst;
        }
        AST aST = lambdaParamsContainer = exprAst != null ? exprAst.getFirstChild() : null;
        if (lambdaParamsContainer != null && lambdaParamsContainer.getType() == 29) {
            for (AST ast : lambdaParamsContainer.getChildren()) {
                this.parameters.add((Parameter)module.createAst(ast, (ModuleElement)this));
            }
        }
        if (exprAst != null) {
            for (AST ast : exprAst.getChildren()) {
                ModuleElement resolved;
                if (!this.parameters.isEmpty() && ast == lambdaParamsContainer || !((resolved = module.createAst(ast, (ModuleElement)this)) instanceof Expression)) continue;
                this.expressions.add((Expression)resolved);
            }
        }
    }

    @Override
    public Object execute(IEolContext context) throws EolRuntimeException {
        EolType iterator;
        Collection<?> target = EolNoType.Instance;
        if (this.targetExpression != null) {
            target = context.getExecutorFactory().execute(this.targetExpression, context);
        } else if (!this.parameters.isEmpty() && (iterator = this.parameters.get(0).getType(context)) instanceof EolModelElementType) {
            target = ((EolModelElementType)iterator).getAllOfKind();
        }
        String operationName = this.nameExpression.getName();
        if (target == null) {
            if (this.isNullSafe()) {
                return null;
            }
            throw new EolNullPointerException(operationName, this.targetExpression);
        }
        IModel owningModel = context.getModelRepository().getOwningModel(target);
        AbstractOperation operation = this.getAbstractOperation(target, operationName, owningModel, context);
        this.replaceWithDelegateOperation(SelectBasedOperation.class, SelectOperation.class, operation, target, operationName, owningModel, context);
        this.replaceWithDelegateOperation(CollectBasedOperation.class, CollectOperation.class, operation, target, operationName, owningModel, context);
        return operation.execute(target, this.nameExpression, this.parameters, this.expressions, context);
    }

    @Override
    protected AbstractOperation getOperationFromContext(Object target, String name, IModel owningModel, IEolContext context) throws EolIllegalOperationException {
        return context.getOperationFactory().getOptimisedOperation(name, target, owningModel, context);
    }

    private <O extends FirstOrderOperation, D extends DelegateBasedOperation<O>> void replaceWithDelegateOperation(Class<D> delegateClass, Class<O> originalClass, AbstractOperation operation, Object target, String originalOpName, IModel owningModel, IEolContext context) throws EolIllegalOperationException {
        DelegateBasedOperation dbo;
        if (delegateClass.isInstance(operation) && (dbo = (DelegateBasedOperation)operation).getDelegateOperation().getClass().equals(originalClass)) {
            String delegateOpName = originalClass.getSimpleName();
            delegateOpName = delegateOpName.substring(0, delegateOpName.indexOf("Operation"));
            delegateOpName = originalOpName.startsWith("parallel") && !StringUtil.firstToLower((String)delegateOpName).startsWith("parallel") ? "parallel" + delegateOpName : (originalOpName.startsWith("sequential") && !StringUtil.firstToLower((String)delegateOpName).startsWith("sequential") ? "sequential" + delegateOpName : StringUtil.firstToLower((String)delegateOpName));
            FirstOrderOperation delegateOp = (FirstOrderOperation)this.getAbstractOperation(target, delegateOpName, owningModel, context);
            if (!delegateOp.getClass().equals(originalClass)) {
                dbo.setDelegateOperation(delegateOp);
            }
        }
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    @Override
    public void accept(IEolVisitor visitor) {
        visitor.visit(this);
    }
}

