/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.dom.NameExpression;
import org.eclipse.epsilon.eol.exceptions.EolIllegalOperationException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.operations.AbstractOperation;
import org.eclipse.epsilon.eol.execute.operations.DynamicOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.IAbstractOperationContributor;
import org.eclipse.epsilon.eol.execute.operations.declarative.IAbstractOperationContributorProvider;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.types.EolSequence;

public abstract class FeatureCallExpression
extends Expression {
    protected boolean arrow;
    protected boolean safe;
    protected Expression targetExpression;
    protected NameExpression nameExpression;

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.arrow = "->".equals(cst.getText());
        this.safe = "?.".equals(cst.getText());
    }

    static Object wrap(Object o) {
        if (o instanceof Object[]) {
            Object[] arr = (Object[])o;
            EolSequence<Object> seq = new EolSequence<Object>();
            seq.ensureCapacity(arr.length);
            Object[] objectArray = arr;
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                seq.add(element);
                ++n2;
            }
            return seq;
        }
        return o;
    }

    protected AbstractOperation getAbstractOperation(Object target, String name, IModel owningModel, IEolContext context) throws EolIllegalOperationException {
        IAbstractOperationContributor contributor;
        AbstractOperation operation = null;
        if (target instanceof IAbstractOperationContributor && (operation = ((IAbstractOperationContributor)target).getAbstractOperation(name)) != null) {
            return operation;
        }
        if (owningModel != null && owningModel instanceof IAbstractOperationContributorProvider && (contributor = ((IAbstractOperationContributorProvider)((Object)owningModel)).getAbstractOperationContributor(target)) != null && (operation = contributor.getAbstractOperation(name)) != null) {
            return operation;
        }
        operation = this.getOperationFromContext(target, name, owningModel, context);
        if (operation == null && this.nameExpression != null) {
            operation = new DynamicOperation();
        }
        return operation;
    }

    protected AbstractOperation getOperationFromContext(Object target, String name, IModel owningModel, IEolContext context) throws EolIllegalOperationException {
        return context.getOperationFactory().getOperationFor(name);
    }

    public Expression getTargetExpression() {
        return this.targetExpression;
    }

    public void setTargetExpression(Expression targetExpression) {
        this.targetExpression = targetExpression;
    }

    public void setNameExpression(NameExpression nameExpression) {
        this.nameExpression = nameExpression;
    }

    public NameExpression getNameExpression() {
        return this.nameExpression;
    }

    public String getName() {
        return this.nameExpression != null ? this.nameExpression.getName() : null;
    }

    public boolean isArrow() {
        return this.arrow;
    }

    public boolean isNullSafe() {
        return this.safe;
    }

    @Override
    public abstract void accept(IEolVisitor var1);
}

