/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import java.util.List;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.dom.AbstractExecutableModuleElement;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.ExpressionStatement;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.dom.IExecutableModuleElement;
import org.eclipse.epsilon.eol.dom.Statement;
import org.eclipse.epsilon.eol.dom.StatementBlock;
import org.eclipse.epsilon.eol.exceptions.EolIllegalReturnException;
import org.eclipse.epsilon.eol.exceptions.EolNoReturnException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.Return;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;

public class ExecutableBlock<T>
extends AbstractExecutableModuleElement {
    protected IExecutableModuleElement body;
    protected Class<? extends T> expectedResultClass;
    protected String role = "";
    protected String text = "";

    public ExecutableBlock(Class<? extends T> expectedResultClass) {
        this.expectedResultClass = expectedResultClass;
    }

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.text = cst.getText();
        if (cst.getType() == 67) {
            StatementBlock statementBlock = new StatementBlock(new Statement[0]);
            statementBlock.setParent(this);
            List<Statement> statements = statementBlock.getStatements();
            for (AST childAst : cst.getChildren()) {
                ModuleElement childModuleElement = module.createAst(childAst, (ModuleElement)statementBlock);
                if (childModuleElement instanceof Statement) {
                    statements.add((Statement)childModuleElement);
                    continue;
                }
                if (!(childModuleElement instanceof Expression)) continue;
                ExpressionStatement expressionStatement = new ExpressionStatement((Expression)childModuleElement);
                expressionStatement.setParent(statementBlock);
                statements.add(expressionStatement);
            }
            this.body = statementBlock;
        } else {
            this.role = cst.getText();
            this.body = (IExecutableModuleElement)module.createAst(cst.getFirstChild(), (ModuleElement)this);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public IExecutableModuleElement getBody() {
        return this.body;
    }

    public void setBody(IExecutableModuleElement body) {
        this.body = body;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public T execute(IEolContext context, Variable ... variables) throws EolRuntimeException {
        return this.execute(context, true, variables);
    }

    public T execute(IEolContext context) throws EolRuntimeException {
        return this.execute(context, new Variable[0]);
    }

    protected Object executeBlockOrExpressionAst(IExecutableModuleElement ast, IEolContext context) throws EolRuntimeException {
        if (ast == null) {
            return null;
        }
        Object result = context.getExecutorFactory().execute(ast, context);
        if (ast instanceof StatementBlock) {
            return result;
        }
        return new Return(result);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public T execute(IEolContext context, boolean inNewFrame, FrameType frameType, Variable ... variables) throws EolRuntimeException {
        Object result;
        ModuleElement oldEntryPoint;
        FrameStack frameStack = context.getFrameStack();
        if (inNewFrame) {
            frameStack.enterLocal(frameType, (ModuleElement)this, new Variable[0]);
        }
        if ((oldEntryPoint = frameStack.getTopFrame().getEntryPoint()) != this) {
            frameStack.getTopFrame().setEntryPoint(this);
        }
        try {
            frameStack.put(variables);
            result = this.executeBody(context);
        }
        finally {
            if (oldEntryPoint != this) {
                frameStack.getTopFrame().setEntryPoint(oldEntryPoint);
            }
        }
        if (inNewFrame) {
            frameStack.leaveLocal(this);
        }
        Object retVal = null;
        Class<T> expResClass = this.getExpectedResultClass();
        if (result instanceof Return) {
            Object value = Return.getValue(result);
            if (expResClass == null) {
                retVal = result;
            } else if (value == null && expResClass == Void.class || expResClass.isInstance(value)) {
                retVal = value;
            } else {
                if (expResClass != String.class || value instanceof String) throw new EolIllegalReturnException(expResClass.getSimpleName(), value, this, context);
                retVal = "" + value;
            }
        } else if (expResClass != Void.class) {
            throw new EolNoReturnException(expResClass.getSimpleName(), this, context);
        }
        this.postExecution();
        return (T)retVal;
    }

    protected void postExecution() {
    }

    public Object executeBody(IEolContext context) throws EolRuntimeException {
        return this.executeBlockOrExpressionAst(this.getBody(), context);
    }

    public T execute(IEolContext context, boolean inNewFrame, Variable ... variables) throws EolRuntimeException {
        return this.execute(context, inNewFrame, FrameType.UNPROTECTED, variables);
    }

    protected Class<? extends T> getExpectedResultClass() {
        return this.expectedResultClass;
    }

    public void accept(IEolVisitor visitor) {
        visitor.visit(this);
    }
}

