/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.dom.LiteralExpression;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.models.ModelRepository;

public class EnumerationLiteralExpression
extends LiteralExpression<Object> {
    protected String enumerationLiteral;

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.enumerationLiteral = cst.getText();
    }

    @Override
    public Object execute(IEolContext context) throws EolRuntimeException {
        Object rawValue = context.getModelRepository().getEnumerationValue(this.enumerationLiteral);
        if (rawValue instanceof ModelRepository.AmbiguousEnumerationValue) {
            ModelRepository.AmbiguousEnumerationValue ambiEnum = (ModelRepository.AmbiguousEnumerationValue)rawValue;
            List quotedNames = ambiEnum.namesOfAlternatives.stream().map(e -> "'" + e + "'").collect(Collectors.toList());
            String spacedQuotedNames = String.join((CharSequence)" ", quotedNames);
            context.getWarningStream().println(String.format("Warning: The enumeration literal '%s' is ambiguous and could refer to any of the following: %s. The enumeration literal '%s' has been assumed. %s", this.enumerationLiteral, spacedQuotedNames, ambiEnum.nameOfSelectedAlternative, EnumerationLiteralExpression.determineLocation(context.getFrameStack().getCurrentStatement())));
            return ambiEnum.selectedValue;
        }
        return rawValue;
    }

    public String getEnumerationLiteral() {
        return this.enumerationLiteral;
    }

    public void setEnumerationLiteral(String enumerationLiteral) {
        this.enumerationLiteral = enumerationLiteral;
    }

    @Override
    public void accept(IEolVisitor visitor) {
        visitor.visit(this);
    }

    private static String determineLocation(ModuleElement statement) {
        if (statement == null) {
            return "";
        }
        return "(" + statement.getFile() + "@" + statement.getRegion().getStart().getLine() + ":" + statement.getRegion().getStart().getColumn() + ")";
    }
}

