/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import java.util.Collection;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.dom.Statement;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.models.ModelRepository;
import org.eclipse.epsilon.eol.types.EolCollectionType;

public class DeleteStatement
extends Statement {
    protected Expression expression;

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.expression = (Expression)module.createAst(cst.getFirstChild(), (ModuleElement)this);
    }

    @Override
    public Void execute(IEolContext context) throws EolRuntimeException {
        Object target = null;
        if (this.expression != null) {
            target = context.getExecutorFactory().execute(this.expression, context);
        }
        Collection col = CollectionUtil.asCollection(target);
        ModelRepository modelRepo = context.getModelRepository();
        for (Object instance : EolCollectionType.clone(col)) {
            IModel model = modelRepo.getOwningModel(instance);
            if (model == null) continue;
            model.deleteElement(instance);
        }
        return null;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    @Override
    public void accept(IEolVisitor visitor) {
        visitor.visit(this);
    }
}

