/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.FeatureCallExpression;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.dom.NameExpression;
import org.eclipse.epsilon.eol.dom.Parameter;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.operations.DynamicOperation;

public class ComplexOperationCallExpression
extends FeatureCallExpression {
    protected LinkedHashMap<Expression, List<Parameter>> complexParameters = new LinkedHashMap(4);

    @Override
    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.targetExpression = (Expression)module.createAst(cst.getFirstChild(), (ModuleElement)this);
        AST exprAst = cst.getSecondChild();
        this.nameExpression = (NameExpression)module.createAst(exprAst, (ModuleElement)this);
        for (AST opArg : exprAst.getChildren()) {
            AST bodyAst;
            List lambdaParams;
            if (opArg.getType() == 69) {
                boolean hasParams;
                boolean bl = hasParams = opArg.getFirstChild().getType() == 29;
                if (hasParams) {
                    lambdaParams = new ArrayList(opArg.getFirstChild().getChildCount());
                    for (AST param : opArg.getFirstChild().getChildren()) {
                        lambdaParams.add((Parameter)module.createAst(param, (ModuleElement)this));
                    }
                } else {
                    lambdaParams = Collections.emptyList();
                }
                bodyAst = hasParams ? opArg.getSecondChild() : opArg.getFirstChild();
            } else {
                lambdaParams = null;
                bodyAst = opArg;
            }
            this.complexParameters.put((Expression)module.createAst(bodyAst, (ModuleElement)this), lambdaParams);
        }
    }

    @Override
    public Object execute(IEolContext context) throws EolRuntimeException {
        Object target = context.getExecutorFactory().execute(this.targetExpression, context);
        if (target == null && this.isNullSafe()) {
            return target;
        }
        return new DynamicOperation().execute(target, this.nameExpression, this.complexParameters, context);
    }

    public LinkedHashMap<Expression, List<Parameter>> getComplexParameters() {
        return this.complexParameters;
    }

    public void setComplexParameters(LinkedHashMap<Expression, List<Parameter>> complexParameters) {
        this.complexParameters = complexParameters;
    }

    @Override
    public void accept(IEolVisitor visitor) {
        visitor.visit(this);
    }
}

