/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.dom.LiteralExpression;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.ExecutorFactory;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.types.EolBag;
import org.eclipse.epsilon.eol.types.EolOrderedSet;
import org.eclipse.epsilon.eol.types.EolSequence;
import org.eclipse.epsilon.eol.types.EolSet;
import org.eclipse.epsilon.eol.types.concurrent.EolConcurrentBag;
import org.eclipse.epsilon.eol.types.concurrent.EolConcurrentSet;

public class CollectionLiteralExpression<T>
extends LiteralExpression<Collection<T>> {
    protected String collectionType;
    protected boolean range;
    protected List<Expression> parameterExpressions = new ArrayList<Expression>();

    public CollectionLiteralExpression() {
    }

    public CollectionLiteralExpression(String collectionType, Expression ... parameterExpressions) {
        this.collectionType = collectionType;
        this.range = false;
        Expression[] expressionArray = parameterExpressions;
        int n = parameterExpressions.length;
        int n2 = 0;
        while (n2 < n) {
            Expression parameterExpression = expressionArray[n2];
            this.parameterExpressions.add(parameterExpression);
            ++n2;
        }
    }

    public CollectionLiteralExpression(String collectionType, boolean range, Expression ... parameterExpressions) {
        this.collectionType = collectionType;
        this.range = range;
        Expression[] expressionArray = parameterExpressions;
        int n = parameterExpressions.length;
        int n2 = 0;
        while (n2 < n) {
            Expression parameterExpression = expressionArray[n2];
            this.parameterExpressions.add(parameterExpression);
            ++n2;
        }
    }

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.collectionType = cst.getText();
        if (cst.getFirstChild() != null) {
            for (AST parameterAst : cst.getFirstChild().getChildren()) {
                this.parameterExpressions.add((Expression)module.createAst(parameterAst, (ModuleElement)this));
            }
            if (cst.getFirstChild().getType() == 60) {
                this.range = true;
            }
        }
    }

    public static <T> Collection<T> createCollection(String collectionType) {
        switch (collectionType) {
            case "List": 
            case "Sequence": {
                return new EolSequence();
            }
            case "Set": {
                return new EolSet();
            }
            case "OrderedSet": {
                return new EolOrderedSet();
            }
            case "Bag": 
            case "Collection": {
                return new EolBag();
            }
            case "ConcurrentBag": {
                return new EolConcurrentBag();
            }
            case "ConcurrentSet": {
                return new EolConcurrentSet();
            }
        }
        return null;
    }

    @Override
    public Collection<T> execute(IEolContext context) throws EolRuntimeException {
        Collection<T> collection = CollectionLiteralExpression.createCollection(this.collectionType);
        if (collection == null) {
            throw new EolRuntimeException("Unknown collection type: " + this.collectionType);
        }
        ExecutorFactory executorFactory = context.getExecutorFactory();
        if (this.range) {
            Expression rangeStartExpression = this.parameterExpressions.get(0);
            Expression rangeEndExpression = this.parameterExpressions.get(1);
            Object rangeStart = executorFactory.execute(rangeStartExpression, context);
            Object rangeEnd = executorFactory.execute(rangeEndExpression, context);
            if (rangeStart instanceof Integer && rangeEnd instanceof Integer) {
                int e;
                int s = (Integer)rangeStart;
                if (s > (e = ((Integer)rangeEnd).intValue())) {
                    int i = s;
                    while (i >= e) {
                        collection.add(i);
                        --i;
                    }
                } else {
                    int i = s;
                    while (i <= e) {
                        collection.add(i);
                        ++i;
                    }
                }
            } else {
                if (!(rangeStart instanceof Integer)) {
                    throw new EolRuntimeException("The start of a range should be of type Integer", rangeStartExpression);
                }
                if (!(rangeEnd instanceof Integer)) {
                    throw new EolRuntimeException("The end of a range should be of type Integer", rangeEndExpression);
                }
            }
        } else {
            for (Expression parameterExpression : this.parameterExpressions) {
                collection.add(executorFactory.execute(parameterExpression, context));
            }
        }
        return collection;
    }

    public String getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(String collectionType) {
        this.collectionType = collectionType;
    }

    @Override
    public void accept(IEolVisitor visitor) {
        visitor.visit(this);
    }

    public List<Expression> getParameterExpressions() {
        return this.parameterExpressions;
    }

    public boolean isRange() {
        return this.range;
    }

    public void setRange(boolean range) {
        this.range = range;
    }
}

