/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.debug;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.eol.debug.BreakpointRequest;
import org.eclipse.epsilon.eol.debug.BreakpointState;

public class BreakpointResult {
    public static final int NOT_FOUND = -1;
    private final BreakpointRequest request;
    private final IModule module;
    private final URI moduleURI;
    private final int line;
    private final int column;
    private final String condition;
    private final BreakpointState state;

    private BreakpointResult(BreakpointRequest request, IModule module, URI moduleURI, int line, int column, String condition, BreakpointState state) {
        this.request = request;
        this.module = module;
        this.moduleURI = moduleURI;
        this.line = line;
        this.column = column;
        this.condition = condition;
        this.state = state;
    }

    public static BreakpointResult failed(BreakpointRequest request) {
        return new BreakpointResult(request, null, null, -1, -1, request.getCondition(), BreakpointState.FAILED);
    }

    public static BreakpointResult verified(BreakpointRequest request, IModule module, int actualLine, Integer actualColumn) {
        return new BreakpointResult(request, module, module.getSourceUri(), actualLine, actualColumn, request.getCondition(), BreakpointState.VERIFIED);
    }

    public static BreakpointResult pending(BreakpointRequest request) {
        Path requestPath = Paths.get(request.getPath(), new String[0]);
        URI requestURI = requestPath.toUri();
        return new BreakpointResult(request, null, requestURI, request.getLine(), request.getColumn(), request.getCondition(), BreakpointState.PENDING);
    }

    public BreakpointRequest getRequest() {
        return this.request;
    }

    public IModule getModule() {
        return this.module;
    }

    public URI getModuleURI() {
        return this.moduleURI;
    }

    public int getLine() {
        return this.line;
    }

    public Integer getColumn() {
        return this.column;
    }

    public BreakpointState getState() {
        return this.state;
    }

    public String getCondition() {
        return this.condition;
    }
}

