/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.debug;

import java.net.URI;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;

public class BreakpointRequest {
    private final Map<URI, Path> uriToPathMappings;
    private final String path;
    private final int line;
    private final int column;
    private final String condition;

    public BreakpointRequest(Map<URI, Path> uriToPathMappings, String path, int line, int column, String condition) {
        this.uriToPathMappings = uriToPathMappings;
        this.path = path;
        this.line = line;
        this.column = column;
        this.condition = condition;
    }

    public String getPath() {
        return this.path;
    }

    public int getLine() {
        return this.line;
    }

    public Map<URI, Path> getUriToPathMappings() {
        return this.uriToPathMappings;
    }

    public String getCondition() {
        return this.condition;
    }

    public Integer getColumn() {
        return this.column;
    }

    public int hashCode() {
        return Objects.hash(this.column, this.line, this.path, this.uriToPathMappings);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BreakpointRequest other = (BreakpointRequest)obj;
        return Objects.equals(this.column, other.column) && this.line == other.line && Objects.equals(this.path, other.path) && Objects.equals(this.uriToPathMappings, other.uriToPathMappings);
    }
}

