/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.util.UriUtil;
import org.eclipse.epsilon.eol.IEolModule;
import org.eclipse.epsilon.eol.IImportManager;
import org.eclipse.epsilon.eol.dom.Import;

public class ImportManager
implements IImportManager {
    protected Map<URI, IModule> cache = new HashMap<URI, IModule>();

    @Override
    public void loadModuleForImport(Import import_, Class<? extends IModule> moduleImplClass, URI baseURI) throws URISyntaxException {
        String importPath = import_.getPath();
        URI importUri = UriUtil.resolve((String)importPath, (URI[])new URI[]{baseURI}).normalize();
        IEolModule parentModule = import_.getParentModule();
        IModule module = this.cache.get(importUri);
        if (module != null) {
            import_.setImportedModule(module);
            import_.setLoaded(true);
        } else {
            try {
                module = moduleImplClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.cache.put(importUri, module);
            if (module instanceof IEolModule) {
                IEolModule eolModule = (IEolModule)module;
                eolModule.setImportManager(this);
                eolModule.setParentModule(parentModule);
            }
            import_.setImportedModule(module);
            import_.load(baseURI);
        }
    }
}

