/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.TokenStream;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.parse.EpsilonParser;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.common.util.AstUtil;
import org.eclipse.epsilon.common.util.ListSet;
import org.eclipse.epsilon.eol.AbstractModule;
import org.eclipse.epsilon.eol.IEolModule;
import org.eclipse.epsilon.eol.IImportManager;
import org.eclipse.epsilon.eol.ImportManager;
import org.eclipse.epsilon.eol.debug.EolDebugger;
import org.eclipse.epsilon.eol.dom.AbortStatement;
import org.eclipse.epsilon.eol.dom.AnnotationBlock;
import org.eclipse.epsilon.eol.dom.AssignmentStatement;
import org.eclipse.epsilon.eol.dom.BooleanLiteral;
import org.eclipse.epsilon.eol.dom.BreakStatement;
import org.eclipse.epsilon.eol.dom.Case;
import org.eclipse.epsilon.eol.dom.CollectionLiteralExpression;
import org.eclipse.epsilon.eol.dom.ComplexOperationCallExpression;
import org.eclipse.epsilon.eol.dom.ContinueStatement;
import org.eclipse.epsilon.eol.dom.DeleteStatement;
import org.eclipse.epsilon.eol.dom.EnumerationLiteralExpression;
import org.eclipse.epsilon.eol.dom.ExecutableAnnotation;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.ExpressionInBrackets;
import org.eclipse.epsilon.eol.dom.ExpressionStatement;
import org.eclipse.epsilon.eol.dom.FirstOrderOperationCallExpression;
import org.eclipse.epsilon.eol.dom.ForStatement;
import org.eclipse.epsilon.eol.dom.IfStatement;
import org.eclipse.epsilon.eol.dom.Import;
import org.eclipse.epsilon.eol.dom.IntegerLiteral;
import org.eclipse.epsilon.eol.dom.ItemSelectorExpression;
import org.eclipse.epsilon.eol.dom.MapLiteralExpression;
import org.eclipse.epsilon.eol.dom.ModelDeclaration;
import org.eclipse.epsilon.eol.dom.ModelDeclarationParameter;
import org.eclipse.epsilon.eol.dom.NameExpression;
import org.eclipse.epsilon.eol.dom.NewInstanceExpression;
import org.eclipse.epsilon.eol.dom.Operation;
import org.eclipse.epsilon.eol.dom.OperationCallExpression;
import org.eclipse.epsilon.eol.dom.OperationList;
import org.eclipse.epsilon.eol.dom.OperatorExpressionFactory;
import org.eclipse.epsilon.eol.dom.Parameter;
import org.eclipse.epsilon.eol.dom.PropertyCallExpression;
import org.eclipse.epsilon.eol.dom.RealLiteral;
import org.eclipse.epsilon.eol.dom.ReturnStatement;
import org.eclipse.epsilon.eol.dom.SimpleAnnotation;
import org.eclipse.epsilon.eol.dom.SpecialAssignmentStatement;
import org.eclipse.epsilon.eol.dom.Statement;
import org.eclipse.epsilon.eol.dom.StatementBlock;
import org.eclipse.epsilon.eol.dom.StringLiteral;
import org.eclipse.epsilon.eol.dom.SwitchStatement;
import org.eclipse.epsilon.eol.dom.TernaryExpression;
import org.eclipse.epsilon.eol.dom.ThrowStatement;
import org.eclipse.epsilon.eol.dom.TransactionStatement;
import org.eclipse.epsilon.eol.dom.TypeExpression;
import org.eclipse.epsilon.eol.dom.VariableDeclaration;
import org.eclipse.epsilon.eol.dom.WhileStatement;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.Return;
import org.eclipse.epsilon.eol.execute.context.EolContext;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.parse.EolLexer;
import org.eclipse.epsilon.eol.parse.EolParser;
import org.eclipse.epsilon.eol.tools.EolSystem;

public class EolModule
extends AbstractModule
implements IEolModule {
    protected StatementBlock main;
    protected IEolContext context;
    protected List<Statement> postOperationStatements = new ArrayList<Statement>();
    protected OperationList declaredOperations = new OperationList();
    protected List<Import> imports = new ArrayList<Import>();
    protected OperationList operations = new OperationList();
    protected List<ModelDeclaration> declaredModelDeclarations;
    protected Set<ModelDeclaration> modelDeclarations;
    private IEolModule parent;
    private IImportManager importManager;
    Class<? extends IEolContext> expectedContextType = IEolContext.class;

    public EolModule() {
        this(null);
    }

    public EolModule(IEolContext context) {
        try {
            this.expectedContextType = this.getClass().getMethod("getContext", new Class[0]).getReturnType();
        }
        catch (ClassCastException | NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        this.setContext(context != null ? context : new EolContext());
    }

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.checkImports(cst);
        for (Map.Entry<String, Class<? extends IModule>> entry : this.getImportConfiguration().entrySet()) {
            this.imports.addAll(this.getImportsByExtension(cst, entry.getKey(), entry.getValue()));
        }
        for (AST operationAst : AstUtil.getChildren((AST)cst, (int[])new int[]{32})) {
            this.declaredOperations.add((Operation)this.createAst(operationAst, (ModuleElement)this));
        }
        List modelDeclarationAsts = AstUtil.getChildren((AST)cst, (int[])new int[]{73});
        this.declaredModelDeclarations = new ArrayList<ModelDeclaration>(modelDeclarationAsts.size());
        for (AST modelDeclarationAst : modelDeclarationAsts) {
            this.declaredModelDeclarations.add((ModelDeclaration)this.createAst(modelDeclarationAst, (ModuleElement)this));
        }
        if (AstUtil.getChild((AST)cst, (int)67) != null) {
            this.main = (StatementBlock)this.createAst(AstUtil.getChild((AST)cst, (int)67), (ModuleElement)this);
            for (AST child : cst.getChildren()) {
                int type = child.getType();
                if (type == 67 || type == 55 || type == 32 || type == 73 || type == 72) continue;
                ModuleElement exprAst = module.createAst(child, (ModuleElement)this);
                Expression expression = exprAst instanceof ReturnStatement ? ((ReturnStatement)exprAst).getReturnedExpression() : (Expression)exprAst;
                ExpressionStatement expressionStatement = new ExpressionStatement(expression);
                expressionStatement.setParent((ModuleElement)this);
                this.postOperationStatements.add(expressionStatement);
            }
        }
        this.operations.addAll(this.getDeclaredOperations());
        for (Import import_ : this.imports) {
            import_.setContext(this.context);
            if (!import_.isLoaded() || !(import_.getModule() instanceof IEolModule)) continue;
            this.operations.addAll(((IEolModule)import_.getModule()).getOperations());
        }
    }

    @Override
    public ModuleElement adapt(AST cst, ModuleElement parentAst) {
        if (cst == null) {
            return null;
        }
        if (this.getParentModule() != null && this.getParentModule() instanceof AbstractModule && cst.getParent() != null) {
            return ((AbstractModule)((Object)this.getParentModule())).adapt(cst, parentAst);
        }
        AST cstParent = cst.getParent();
        if (cstParent != null && cstParent.getType() == 66 && cst.getType() == 67) {
            return new StatementBlock(new Statement[0]);
        }
        OperatorExpressionFactory operatorExpressionFactory = new OperatorExpressionFactory();
        if (parentAst == null) {
            return this;
        }
        switch (cst.getType()) {
            case 34: {
                return new ForStatement();
            }
            case 38: {
                return new WhileStatement();
            }
            case 40: 
            case 41: {
                return new Case();
            }
            case 39: {
                return new SwitchStatement();
            }
            case 35: {
                return new IfStatement();
            }
            case 79: {
                return new ItemSelectorExpression();
            }
            case 9: 
            case 11: 
            case 12: {
                AST secondChild = cst.getSecondChild();
                if (!secondChild.hasChildren()) {
                    return new PropertyCallExpression();
                }
                if (secondChild.getExtraTokens().size() >= 2) {
                    if (secondChild.getChildren().stream().anyMatch(ast -> ast.getType() == 69)) {
                        return new ComplexOperationCallExpression();
                    }
                    return new FirstOrderOperationCallExpression();
                }
                return new OperationCallExpression();
            }
            case 23: {
                if (cst.hasChildren()) {
                    AST firstChild = cst.getFirstChild();
                    if (firstChild.getType() == 29) {
                        return new FirstOrderOperationCallExpression();
                    }
                    if (firstChild.getExtraTokens().size() >= 1) {
                        if (firstChild.getChildren().stream().anyMatch(ast -> ast.getType() == 69)) {
                            return new ComplexOperationCallExpression();
                        }
                        return new FirstOrderOperationCallExpression();
                    }
                }
                return new NameExpression();
            }
            case 28: {
                return new Parameter();
            }
            case 67: {
                return new StatementBlock(new Statement[0]);
            }
            case 68: {
                int parentType = cstParent.getType();
                if (cst.hasChildren() && cst.getFirstChild().getType() == 51 && (parentType != 11 && parentType != 9 && parentType != 12 || (parentType == 11 || parentType == 9 || parentType == 12) && cstParent.getFirstChild() == cst)) {
                    return new OperationCallExpression(true);
                }
                return new NameExpression();
            }
            case 15: {
                return new StringLiteral();
            }
            case 8: {
                return new IntegerLiteral();
            }
            case 13: {
                return new BooleanLiteral();
            }
            case 4: {
                return new RealLiteral();
            }
            case 30: {
                return new AssignmentStatement();
            }
            case 31: {
                return new SpecialAssignmentStatement();
            }
            case 64: {
                return new ExpressionInBrackets();
            }
            case 53: {
                return new VariableDeclaration();
            }
            case 54: {
                if (cst.getFirstChild().getType() == 70) {
                    return new NewInstanceExpression();
                }
                return new VariableDeclaration();
            }
            case 72: {
                return new Import();
            }
            case 63: {
                if (cst.getText().equals("=") && ((parentAst instanceof IfStatement || parentAst instanceof ForStatement || parentAst instanceof WhileStatement) && cstParent.getFirstChild() != cst || parentAst instanceof StatementBlock)) {
                    return new AssignmentStatement();
                }
                return operatorExpressionFactory.createOperatorExpression(cst);
            }
            case 37: {
                return new TernaryExpression();
            }
            case 45: {
                return new ContinueStatement();
            }
            case 57: {
                return new DeleteStatement();
            }
            case 32: {
                return new Operation();
            }
            case 42: {
                return new ReturnStatement();
            }
            case 71: {
                return new EnumerationLiteralExpression();
            }
            case 27: {
                return new SimpleAnnotation();
            }
            case 56: {
                return new ExecutableAnnotation();
            }
            case 55: {
                return new AnnotationBlock();
            }
            case 47: 
            case 80: {
                boolean isMap = cst.getType() == 80;
                String typeName = cst.getText();
                if (isMap && MapLiteralExpression.createMap(typeName) != null) {
                    return new MapLiteralExpression();
                }
                if (CollectionLiteralExpression.createCollection(typeName) != null) {
                    return new CollectionLiteralExpression();
                }
                this.getParseProblems().add(new ParseProblem("Unknown " + (isMap ? "collection" : "map") + " type: " + typeName, (ModuleElement)this));
            }
            case 70: {
                return new TypeExpression();
            }
            case 43: {
                return new BreakStatement(false);
            }
            case 44: {
                return new BreakStatement(true);
            }
            case 58: {
                return new ThrowStatement();
            }
            case 48: {
                return new AbortStatement();
            }
            case 46: {
                return new TransactionStatement();
            }
            case 73: {
                return new ModelDeclaration();
            }
            case 78: {
                return new ModelDeclarationParameter();
            }
        }
        return null;
    }

    @Override
    protected Lexer createLexer(ANTLRInputStream inputStream) {
        return new EolLexer((CharStream)inputStream);
    }

    @Override
    public EpsilonParser createParser(TokenStream tokenStream) {
        return new EolParser(tokenStream);
    }

    @Override
    public String getMainRule() {
        return "eolModule";
    }

    @Override
    public OperationList getDeclaredOperations() {
        return this.declaredOperations;
    }

    protected HashMap<String, Class<? extends IModule>> getImportConfiguration() {
        HashMap<String, Class<? extends IModule>> importConfiguration = new HashMap<String, Class<? extends IModule>>(4);
        importConfiguration.put("eol", EolModule.class);
        return importConfiguration;
    }

    protected void prepareContext() throws EolRuntimeException {
        IEolContext context = this.getContext();
        EolSystem system = new EolSystem();
        system.setContext(context);
        context.setModule(this);
        context.getFrameStack().putGlobal(Variable.createReadOnlyVariable("null", null), Variable.createReadOnlyVariable("System", system));
    }

    @Override
    public List<Import> getImports() {
        return this.imports;
    }

    public String toString() {
        if (this.sourceFile != null) {
            return this.sourceFile.getAbsolutePath();
        }
        return super.toString();
    }

    @Override
    public Set<ModelDeclaration> getModelDeclarations() {
        if (this.modelDeclarations == null) {
            this.modelDeclarations = new ListSet();
            for (Import import_ : this.imports) {
                if (!import_.isLoaded() || !(import_.getModule() instanceof IEolModule)) continue;
                this.modelDeclarations.addAll(((IEolModule)import_.getModule()).getModelDeclarations());
            }
            this.modelDeclarations.addAll(this.getDeclaredModelDeclarations());
        }
        return this.modelDeclarations;
    }

    @Override
    public OperationList getOperations() {
        return this.operations;
    }

    protected Collection<Import> getImportsByExtension(AST cst, String extension, Class<? extends IModule> moduleImplClass) {
        List importAsts = AstUtil.getChildren((AST)cst, (int[])new int[]{72});
        ArrayList<Import> imports = new ArrayList<Import>(importAsts.size());
        for (AST importAst : importAsts) {
            Import import_ = (Import)this.createAst(importAst, (ModuleElement)this);
            if (!import_.getPath().endsWith("." + extension)) continue;
            import_.setParentModule(this);
            URI uri = null;
            if (this.sourceUri != null) {
                uri = this.sourceUri;
            } else if (this.sourceFile != null) {
                uri = this.sourceFile.toURI();
            }
            try {
                this.getImportManager().loadModuleForImport(import_, moduleImplClass, uri);
                if (!import_.isLoaded()) {
                    ParseProblem problem = new ParseProblem();
                    problem.setLine(import_.getRegion().getStart().getLine());
                    String reason = !import_.isFound() ? String.format("File %s not found", import_.getPath()) : String.format("File %s contains errors: %s", import_.getPath(), import_.getModule().getParseProblems());
                    problem.setReason(reason);
                    this.getParseProblems().add(problem);
                }
            }
            catch (URISyntaxException ex) {
                ParseProblem problem = new ParseProblem();
                problem.setLine(import_.getRegion().getStart().getLine());
                problem.setReason("Imported URI is invalid: " + uri);
                this.getParseProblems().add(problem);
            }
            imports.add(import_);
        }
        return imports;
    }

    protected void checkImports(AST cst) {
        for (AST importAst : AstUtil.getChildren((AST)cst, (int[])new int[]{72})) {
            String importedFile = importAst.getFirstChild().getText();
            boolean validExtension = false;
            for (String extension : this.getImportConfiguration().keySet()) {
                if (!importedFile.endsWith("." + extension)) continue;
                validExtension = true;
            }
            if (validExtension) continue;
            ParseProblem problem = new ParseProblem();
            problem.setLine(importAst.getLine());
            problem.setReason("Importing " + importAst.getFirstChild().getText() + " is not supported in this language");
            problem.setSeverity(1);
            this.getParseProblems().add(problem);
        }
    }

    @Override
    public List<ModelDeclaration> getDeclaredModelDeclarations() {
        return this.declaredModelDeclarations;
    }

    @Override
    public IEolModule getParentModule() {
        return this.parent;
    }

    @Override
    public void setParentModule(IEolModule parent) {
        this.parent = parent;
    }

    @Override
    public Object execute() throws EolRuntimeException {
        IEolContext context = this.getContext();
        this.prepareContext();
        return context.getExecutorFactory().execute((ModuleElement)this, context);
    }

    public Object executeImpl() throws EolRuntimeException {
        IEolContext context = this.getContext();
        return Return.getValue(context.getExecutorFactory().execute(this.main, context));
    }

    @Override
    public List<Statement> getPostOperationStatements() {
        return this.postOperationStatements;
    }

    @Override
    public StatementBlock getMain() {
        return this.main;
    }

    public void setMain(StatementBlock main) {
        this.main = main;
    }

    @Override
    public IEolContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(IEolContext context) {
        if (context != null && !this.expectedContextType.isInstance(context)) {
            throw new IllegalArgumentException("Invalid context type: expected " + this.expectedContextType.getName() + " but got " + context.getClass().getName());
        }
        if (this.context != context) {
            this.context = context;
            if (context.getModule() == null) {
                context.setModule(this);
            }
            for (Import import_ : this.getImports()) {
                import_.setContext(context);
            }
        }
    }

    public void clearCache() {
        for (Operation op : this.getOperations()) {
            op.clearCache();
        }
        this.getContext().getExtendedProperties().clear();
    }

    @Override
    public IImportManager getImportManager() {
        if (this.importManager == null) {
            this.importManager = new ImportManager();
        }
        return this.importManager;
    }

    @Override
    public void setImportManager(IImportManager importManager) {
        this.importManager = importManager;
    }

    @Override
    public EolDebugger createDebugger() {
        return new EolDebugger();
    }
}

