/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol;

import org.eclipse.epsilon.eol.EolModule;
import org.eclipse.epsilon.eol.IEolModule;
import org.eclipse.epsilon.eol.execute.context.EolContext;
import org.eclipse.epsilon.eol.execute.context.IEolContext;

public class EolEngine {
    protected IEolContext context;
    protected IEolModule module;

    public EolEngine() {
        this.reset();
    }

    public void reset() {
        this.module = new EolModule();
        this.context = new EolContext();
        this.context.setModule(this.module);
    }

    public Object execute(String code) throws Exception {
        this.module.parse(code);
        return this.module.execute();
    }

    public void shutdown() {
        this.context.getModelRepository().dispose();
        this.context.dispose();
    }

    public static void main(String[] args) throws Exception {
        EolEngine engine = new EolEngine();
        engine.execute("var i : Integer;");
        engine.execute("i := 5;");
        engine.execute("i.println();");
        engine.shutdown();
    }

    public IEolContext getContext() {
        return this.context;
    }
}

