/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.emf.m0;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.emc.emf.EmfModel;
import org.eclipse.epsilon.eol.EolModule;
import org.eclipse.epsilon.eol.IEolModule;
import org.eclipse.epsilon.eol.dom.Operation;
import org.eclipse.epsilon.eol.exceptions.EolIllegalPropertyException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.introspection.AbstractPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.AbstractPropertySetter;
import org.eclipse.epsilon.eol.execute.introspection.IReflectivePropertySetter;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.models.IRelativePathResolver;

public class EmfM0Model
extends EmfModel {
    protected File m0SpecificationFile;
    protected IEolModule eolModule;

    public EmfM0Model() {
        this.propertyGetter = new EmfM0PropertyGetter();
    }

    @Override
    public void load(StringProperties properties, IRelativePathResolver resolver) throws EolModelLoadingException {
        this.m0SpecificationFile = new File(resolver.resolve(properties.getProperty("m0SpecificationFile")));
        super.load(properties, resolver);
    }

    @Override
    protected void loadModel() throws EolModelLoadingException {
        super.loadModel();
        this.eolModule = new EolModule();
        try {
            this.eolModule.parse(this.m0SpecificationFile);
            this.eolModule.execute();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        EmfModel copy = new EmfModel();
        copy.getAliases().addAll(this.getAliases());
        copy.setMetamodelFiles(this.getMetamodelFiles());
        copy.setMetamodelUris(this.getMetamodelUris());
        copy.setModelFile(this.getModelFile());
        copy.setMetamodelFileBased(this.isMetamodelFileBased());
        copy.setResource(this.getResource());
        copy.setReadOnLoad(this.isReadOnLoad());
        copy.setStoredOnDisposal(this.isStoredOnDisposal());
        copy.setName("Model");
        this.eolModule.getContext().getModelRepository().addModel((IModel)copy);
    }

    public Operation getHelper(String name) {
        return this.eolModule.getDeclaredOperations().stream().filter(helper -> helper.getName().equals(name)).findAny().orElse(null);
    }

    @Override
    public IReflectivePropertySetter getPropertySetter() {
        return new EmfM0PropertySetter();
    }

    @Override
    protected Collection<EObject> getAllOfTypeFromModel(String metaClass) throws EolModelElementTypeNotFoundException {
        Operation allOfTypeHelper = this.getHelper("allOfType");
        Collection allOfType = null;
        try {
            allOfType = (Collection)allOfTypeHelper.execute((Object)metaClass, new ArrayList(), this.eolModule.getContext());
        }
        catch (EolRuntimeException rex) {
            this.eolModule.getContext().getErrorStream().print((Object)rex);
        }
        return allOfType;
    }

    @Override
    public Object getCacheKeyForType(String type) throws EolModelElementTypeNotFoundException {
        return null;
    }

    @Override
    protected Collection<EObject> getAllOfKindFromModel(String metaClass) throws EolModelElementTypeNotFoundException {
        Operation allOfKindHelper = this.getHelper("allOfKind");
        Collection allOfKind = null;
        try {
            allOfKind = (Collection)allOfKindHelper.execute((Object)metaClass, new ArrayList(), this.eolModule.getContext());
        }
        catch (EolRuntimeException rex) {
            this.eolModule.getContext().getErrorStream().print((Object)rex);
        }
        return allOfKind;
    }

    @Override
    public boolean hasType(String type) {
        Operation hasTypeHelper = this.getHelper("hasType");
        boolean hasType = false;
        try {
            hasType = (Boolean)hasTypeHelper.execute((Object)type, new ArrayList(0), this.eolModule.getContext());
        }
        catch (EolRuntimeException rex) {
            this.eolModule.getContext().getErrorStream().print((Object)rex);
        }
        return hasType;
    }

    public File getM0SpecificationFile() {
        return this.m0SpecificationFile;
    }

    public void setM0SpecificationFile(File specification) {
        this.m0SpecificationFile = specification;
    }

    public IEolModule getEolModule() {
        return this.eolModule;
    }

    public void setEolModule(IEolModule eolModule) {
        this.eolModule = eolModule;
    }

    class EmfM0PropertyGetter
    extends AbstractPropertyGetter {
        EmfM0PropertyGetter() {
        }

        public Object invoke(Object object, String property, IEolContext context) throws EolRuntimeException {
            ArrayList<String> parameterValues = new ArrayList<String>();
            parameterValues.add(property);
            Operation propertyGetter = EmfM0Model.this.eolModule.getDeclaredOperations().getOperation(object, "getProperty", parameterValues, EmfM0Model.this.eolModule.getContext());
            if (propertyGetter != null) {
                return propertyGetter.execute(object, parameterValues, EmfM0Model.this.eolModule.getContext());
            }
            return null;
        }
    }

    class EmfM0PropertySetter
    extends AbstractPropertySetter
    implements IReflectivePropertySetter {
        EmfM0PropertySetter() {
        }

        public void invoke(Object target, String property, Object value, IEolContext context) throws EolRuntimeException {
            ArrayList<Object> parameterValues = new ArrayList<Object>();
            parameterValues.add(property);
            parameterValues.add(value);
            Operation propertySetter = EmfM0Model.this.eolModule.getDeclaredOperations().getOperation(target, "setProperty", parameterValues, EmfM0Model.this.eolModule.getContext());
            if (propertySetter != null) {
                propertySetter.execute(target, parameterValues, EmfM0Model.this.eolModule.getContext());
            }
        }

        public Object coerce(Object target, String property, Object value, IEolContext context) throws EolIllegalPropertyException {
            return value;
        }

        public boolean conforms(Object target, String property, Object value, IEolContext context) throws EolIllegalPropertyException {
            return true;
        }
    }
}

