/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.emf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.epsilon.emc.emf.EmfModel;
import org.eclipse.epsilon.emc.emf.EmfUtil;

public class InMemoryEmfModel
extends EmfModel {
    public InMemoryEmfModel(String name, Resource modelImpl, EPackage ... ePackages) {
        this.init(name, modelImpl, Arrays.asList(ePackages), true);
    }

    public InMemoryEmfModel(String name, Resource modelImpl, String ... nsUris) {
        ArrayList<EPackage> ePackages = new ArrayList<EPackage>();
        String[] stringArray = nsUris;
        int n = nsUris.length;
        int n2 = 0;
        while (n2 < n) {
            String nsUri = stringArray[n2];
            ePackages.add(EPackage.Registry.INSTANCE.getEPackage(nsUri));
            ++n2;
        }
        this.init(name, modelImpl, ePackages, true);
    }

    public InMemoryEmfModel(Resource modelImpl) {
        this(modelImpl, true);
    }

    public InMemoryEmfModel(Resource modelImpl, boolean isContainerListenerEnabled) {
        this.init("Model", modelImpl, Collections.emptyList(), isContainerListenerEnabled);
    }

    public InMemoryEmfModel(String name, Resource modelImpl) {
        this(name, modelImpl, Collections.emptyList(), true);
    }

    public InMemoryEmfModel(String name, Resource modelImpl, boolean isContainerListenerEnabled) {
        this.init(name, modelImpl, Collections.emptyList(), isContainerListenerEnabled);
    }

    public InMemoryEmfModel(String name, Resource modelImpl, Collection<EPackage> ePackages) {
        this(name, modelImpl, ePackages, true);
    }

    public InMemoryEmfModel(String name, Resource modelImpl, Collection<EPackage> ePackages, boolean isContainerListenerEnabled) {
        this.init(name, modelImpl, ePackages, isContainerListenerEnabled);
    }

    public InMemoryEmfModel(String name, Resource modelImpl, Collection<EPackage> ePackages, boolean isContainerListenerEnabled, boolean expand) {
        this.setExpand(expand);
        this.init(name, modelImpl, ePackages, isContainerListenerEnabled);
    }

    protected void init(String name, Resource modelImpl, Collection<EPackage> ePackages, boolean isContainerListenerEnabled) {
        Resource.Factory.Registry rfReg;
        this.setName(name);
        this.modelImpl = modelImpl;
        ResourceSet resourceSet = modelImpl.getResourceSet();
        if (resourceSet != null && (rfReg = resourceSet.getResourceFactoryRegistry()) == null) {
            resourceSet.setResourceFactoryRegistry(Resource.Factory.Registry.INSTANCE);
        }
        if (ePackages == null || ePackages.isEmpty()) {
            if (resourceSet != null && resourceSet.getPackageRegistry().isEmpty()) {
                resourceSet.setPackageRegistry(EPackage.Registry.INSTANCE);
            }
        } else {
            EPackage.Registry epReg = this.getPackageRegistry();
            for (EPackage ePackage : ePackages) {
                epReg.put((Object)ePackage.getNsURI(), (Object)ePackage);
                ArrayList<EPackage> dependencies = new ArrayList<EPackage>();
                EmfUtil.collectDependencies(ePackage, dependencies);
                for (EPackage dependency : dependencies) {
                    epReg.put((Object)dependency.getNsURI(), (Object)dependency);
                }
            }
        }
        this.setCachingEnabled(true);
        if (isContainerListenerEnabled) {
            this.setupContainmentChangeListeners();
        }
    }

    @Override
    public void loadModel() {
    }
}

