/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.emf;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.epsilon.common.util.OperatingSystem;
import org.eclipse.epsilon.common.util.StringUtil;

public class EmfUtil {
    private static final URI DEFAULT_URI = URI.createFileURI((String)"foo.ecore");

    private EmfUtil() {
    }

    public static URI createUri(String uri) {
        return uri == null ? null : URI.createURI((String)uri.replace('\\', '/').replaceAll(" ", "%20"));
    }

    public static URI convertFileToUri(File file) {
        return file == null ? null : URI.createFileURI((String)file.getAbsolutePath());
    }

    public static EStructuralFeature getEStructuralFeature(EClass eClass, String featureName) {
        try {
            EClass documentRoot;
            EStructuralFeature feature = eClass.getEStructuralFeature(featureName);
            if (feature == null && (documentRoot = ExtendedMetaData.INSTANCE.getDocumentRoot(eClass.getEPackage())) != null) {
                feature = documentRoot.getEStructuralFeature(featureName);
            }
            return feature;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static String createFullyQualifiedUri(String relativePath) {
        return StringUtil.isEmpty((String)relativePath) ? "" : EmfUtil.createPlatformResourceURI(relativePath).toString();
    }

    public static URI createPlatformResourceURI(String s) {
        URI uri = EmfUtil.fixUriForOperatingSystem(s, URI.createURI((String)s));
        if (uri.scheme() == null) {
            return URI.createPlatformResourceURI((String)s, (boolean)true);
        }
        return uri;
    }

    public static URI createFileBasedURI(String s) {
        URI uri = EmfUtil.fixUriForOperatingSystem(s, URI.createURI((String)s));
        if (uri.scheme() == null) {
            return URI.createFileURI((String)s);
        }
        return uri;
    }

    private static URI fixUriForOperatingSystem(String s, URI uri) {
        if (uri.scheme() != null && OperatingSystem.isWindows() && uri.scheme().length() == 1) {
            return URI.createFileURI((String)s);
        }
        return uri;
    }

    public static String getFile(URI uri) {
        if (uri.isFile()) {
            return uri.toFileString();
        }
        return uri.toString();
    }

    public static EPackage toEPackage(Object o) {
        if (o instanceof EPackage) {
            return (EPackage)o;
        }
        if (o instanceof EPackage.Descriptor) {
            return ((EPackage.Descriptor)o).getEPackage();
        }
        throw new ClassCastException(o + " is not an EPackage");
    }

    public static boolean isEPackageOrDescriptor(Object o) {
        return o instanceof EPackage || o instanceof EPackage.Descriptor;
    }

    public static EPackage getTopEPackage(EObject object) {
        return EmfUtil.getTopEPackage(object.eClass().getEPackage());
    }

    public static void collectDependencies(EPackage ePackage, List<EPackage> dependencies) {
        Set crossReferencedElements = EcoreUtil.ExternalCrossReferencer.find((Resource)ePackage.eResource()).keySet();
        for (Object crossReferencedElement : crossReferencedElements) {
            EPackage topEPackage;
            EClassifier eClass;
            EPackage referencedPackage;
            if (!(crossReferencedElement instanceof EClassifier) || (referencedPackage = (eClass = (EClassifier)crossReferencedElement).getEPackage()) == null || dependencies.contains(topEPackage = EmfUtil.getTopEPackage(referencedPackage))) continue;
            dependencies.add(topEPackage);
            EmfUtil.collectDependencies(topEPackage, dependencies);
        }
    }

    public static EPackage getTopEPackage(EPackage ePackage) {
        EPackage top = ePackage;
        while (top.getESuperPackage() != null) {
            top = top.getESuperPackage();
        }
        return top;
    }

    private static void initialiseResourceFactoryRegistry() {
        Map etfm = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap();
        if (!etfm.containsKey("*")) {
            etfm.put("*", new XMIResourceFactoryImpl());
        }
    }

    public static List<EPackage> register(URI uri, EPackage.Registry registry) throws Exception {
        return EmfUtil.register(uri, registry, true);
    }

    public static List<EPackage> register(File file, EPackage.Registry registry) throws Exception {
        return EmfUtil.register(EmfUtil.convertFileToUri(file), registry, true);
    }

    public static List<EPackage> register(URI uri, EPackage.Registry registry, boolean useUriForResource) throws Exception {
        ArrayList<EPackage> ePackages = new ArrayList<EPackage>();
        EmfUtil.initialiseResourceFactoryRegistry();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getPackageRegistry().put((Object)EcorePackage.eINSTANCE.getNsURI(), (Object)EcorePackage.eINSTANCE);
        Resource metamodel = resourceSet.createResource(uri);
        metamodel.load(Collections.EMPTY_MAP);
        EmfUtil.setDataTypesInstanceClasses(metamodel);
        TreeIterator it = metamodel.getAllContents();
        while (it.hasNext()) {
            Object next = it.next();
            if (!(next instanceof EPackage)) continue;
            EPackage p = (EPackage)next;
            EmfUtil.adjustNsAndPrefix(metamodel, p, useUriForResource);
            registry.put((Object)p.getNsURI(), (Object)p);
            ePackages.add(p);
        }
        return ePackages;
    }

    public static List<EPackage> registerXcore(URI locationURI, EPackage.Registry registry) throws IOException {
        return EmfUtil.registerXcore(locationURI, registry, true);
    }

    public static List<EPackage> registerXcore(URI locationURI, EPackage.Registry registry, boolean useUriForResource) throws IOException {
        ArrayList<EPackage> ePackages = new ArrayList<EPackage>();
        EmfUtil.initialiseResourceFactoryRegistry();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap((boolean)true));
        Resource metamodel = resourceSet.getResource(locationURI, true);
        metamodel.load(Collections.EMPTY_MAP);
        EcoreUtil.resolveAll((Resource)metamodel);
        EPackage ePackage = (EPackage)EcoreUtil.getObjectByType((Collection)metamodel.getContents(), (EClassifier)EcorePackage.Literals.EPACKAGE);
        if (ePackage != null) {
            EmfUtil.adjustNsAndPrefix(metamodel, ePackage, useUriForResource);
            registry.put((Object)ePackage.getNsURI(), (Object)ePackage);
            ePackages.add(ePackage);
        }
        return ePackages;
    }

    public static List<EPackage> registerXcore(URI locationURI) throws IOException {
        return EmfUtil.registerXcore(locationURI, true);
    }

    public static List<EPackage> registerXcore(URI locationURI, boolean useUriForResource) throws IOException {
        ArrayList<EPackage> ePackages = new ArrayList<EPackage>();
        EmfUtil.initialiseResourceFactoryRegistry();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap((boolean)true));
        Resource metamodel = resourceSet.createResource(locationURI);
        metamodel.load(Collections.EMPTY_MAP);
        EmfUtil.setDataTypesInstanceClasses(metamodel);
        EPackage ePackage = (EPackage)EcoreUtil.getObjectByType((Collection)metamodel.getContents(), (EClassifier)EcorePackage.Literals.EPACKAGE);
        if (ePackage != null) {
            EmfUtil.adjustNsAndPrefix(metamodel, ePackage, useUriForResource);
            metamodel.getContents().remove((Object)ePackage);
            EPackage.Registry.INSTANCE.put((Object)ePackage.getNsURI(), (Object)ePackage);
            ePackages.add(ePackage);
        }
        return ePackages;
    }

    protected static void setDataTypesInstanceClasses(Resource metamodel) {
        TreeIterator iterator = metamodel.getAllContents();
        while (iterator.hasNext()) {
            String typeName;
            EObject eObject = (EObject)iterator.next();
            if (eObject instanceof EEnum || !(eObject instanceof EDataType)) continue;
            EDataType eDataType = (EDataType)eObject;
            switch (typeName = eDataType.getName()) {
                case "String": 
                case "Integer": 
                case "Float": 
                case "Boolean": 
                case "Double": {
                    eDataType.setInstanceClassName("java.lang." + typeName);
                }
            }
        }
    }

    public static List<EClass> getAllEClassesFromSameMetamodelAs(EModelElement metamodelElement) {
        return EmfUtil.getAllModelElementsOfType((EObject)metamodelElement, EClass.class);
    }

    public static Collection<EClassifier> getAllEClassifiers(EPackage epackage) {
        ArrayList<EClassifier> allEClassifiers = new ArrayList<EClassifier>();
        allEClassifiers.addAll((Collection<EClassifier>)epackage.getEClassifiers());
        for (EPackage subpackage : epackage.getESubpackages()) {
            allEClassifiers.addAll(EmfUtil.getAllEClassifiers(subpackage));
        }
        return allEClassifiers;
    }

    public static <T extends EObject> List<T> getAllModelElementsOfType(EObject modelElement, Class<T> type) {
        LinkedList<EObject> results = new LinkedList<EObject>();
        if (modelElement.eResource() != null) {
            TreeIterator iterator = modelElement.eResource().getAllContents();
            while (iterator.hasNext()) {
                EObject object = (EObject)iterator.next();
                if (!type.isInstance(object)) continue;
                results.add(object);
            }
        }
        return Collections.unmodifiableList(results);
    }

    public static Resource createResource() {
        return EmfUtil.createResource(DEFAULT_URI);
    }

    public static Resource createResource(URI uri) {
        return EmfUtil.createResource(null, uri);
    }

    public static Resource createResource(EObject rootObject) {
        return EmfUtil.createResource(rootObject, DEFAULT_URI);
    }

    public static Resource createResource(EObject rootObject, URI uri) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new EcoreResourceFactoryImpl());
        Resource resource = resourceSet.createResource(uri);
        if (rootObject != null) {
            resource.getContents().add((Object)rootObject);
        }
        return resource;
    }

    public static <T extends EObject> T clone(T object) {
        EObject cloned = EcoreUtil.copy(object);
        EmfUtil.createResource(cloned);
        return (T)cloned;
    }

    public static List<EObject> getAllContents(Resource r) {
        LinkedList<EObject> allContents = new LinkedList<EObject>();
        TreeIterator it = r.getAllContents();
        while (it.hasNext()) {
            allContents.add((EObject)it.next());
        }
        return allContents;
    }

    public static int instancesCount(Resource r) {
        int i = 0;
        TreeIterator ite = r.getAllContents();
        while (ite.hasNext()) {
            ++i;
            ite.next();
        }
        return i;
    }

    private static void adjustNsAndPrefix(Resource metamodel, EPackage p, boolean useUriForResource) {
        if (p.getNsURI() == null || p.getNsURI().trim().length() == 0) {
            if (p.getESuperPackage() == null) {
                p.setNsURI(p.getName());
            } else {
                p.setNsURI(String.valueOf(p.getESuperPackage().getNsURI()) + "/" + p.getName());
            }
        }
        if ((p.getNsPrefix() == null || p.getNsPrefix().trim().length() == 0) && p.getESuperPackage() != null) {
            if (p.getESuperPackage().getNsPrefix() != null) {
                p.setNsPrefix(String.valueOf(p.getESuperPackage().getNsPrefix()) + "." + p.getName());
            } else {
                p.setNsPrefix(p.getName());
            }
        }
        if (p.getNsPrefix() == null) {
            p.setNsPrefix(p.getName());
        }
        if (useUriForResource) {
            metamodel.setURI(URI.createURI((String)p.getNsURI()));
        }
    }

    public static Diagnostic validate(Resource resource) {
        return EmfUtil.validate(resource, new BasicDiagnostic());
    }

    public static Diagnostic validate(ResourceSet resourceSet) {
        BasicDiagnostic diagnostic = new BasicDiagnostic();
        for (Resource resource : resourceSet.getResources()) {
            EmfUtil.validate(resource, diagnostic);
        }
        return diagnostic;
    }

    protected static Diagnostic validate(Resource resource, BasicDiagnostic diagnostic) {
        Diagnostician diagnostician = new Diagnostician();
        for (EObject o : resource.getContents()) {
            diagnostician.validate(o, (DiagnosticChain)diagnostic);
        }
        return diagnostic;
    }
}

