/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.emf;

import java.util.Collection;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.emc.emf.EmfUtil;
import org.eclipse.epsilon.eol.exceptions.EolIllegalPropertyAssignmentException;
import org.eclipse.epsilon.eol.exceptions.EolIllegalPropertyException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.introspection.AbstractPropertySetter;
import org.eclipse.epsilon.eol.execute.introspection.IReflectivePropertySetter;

public class EmfPropertySetter
extends AbstractPropertySetter
implements IReflectivePropertySetter {
    public Object coerce(Object target, String property, Object value, IEolContext context) throws EolIllegalPropertyException {
        EStructuralFeature sf = this.getEStructuralFeature(target, property, value, context);
        if (sf.isMany() && !(value instanceof Collection)) {
            return CollectionUtil.asList((Object)value);
        }
        return value;
    }

    public boolean conforms(Object target, String property, Object value, IEolContext context) throws EolIllegalPropertyException {
        EStructuralFeature sf = this.getEStructuralFeature(target, property, value, context);
        if (!sf.isChangeable()) {
            return false;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return sf.isMany() && this.isConformantSizeForProperty(collection, sf) && this.allAreConformantTypeForProperty(collection, sf);
        }
        return sf.getEType().isInstance(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invoke(Object target, String property, Object value, IEolContext context) throws EolRuntimeException {
        EStructuralFeature sf = this.getEStructuralFeature(target, property, value, context);
        if (sf.isMany()) {
            if (value == null) return;
            Collection sourceValues = (Collection)this.getEObject(target, property, value, context).eGet(sf);
            if (!(value instanceof Collection)) throw new EolIllegalPropertyAssignmentException(property, context);
            this.copyCollectionValues((Collection)value, sourceValues);
            return;
        } else {
            this.getEObject(target, property, value, context).eSet(sf, value);
        }
    }

    protected void copyCollectionValues(Collection<?> source, Collection<Object> target) {
        target.clear();
        target.addAll(source);
    }

    protected EObject getEObject(Object object, String property, Object value, IEolContext context) throws EolIllegalPropertyException {
        if (object instanceof EObject) {
            return (EObject)object;
        }
        throw new EolIllegalPropertyException(object, property, context);
    }

    private EStructuralFeature getEStructuralFeature(Object object, String property, Object value, IEolContext context) throws EolIllegalPropertyException {
        EStructuralFeature sf = EmfUtil.getEStructuralFeature(this.getEObject(object, property, value, context).eClass(), property);
        if (sf == null) {
            throw new EolIllegalPropertyException(object, property, context);
        }
        return sf;
    }

    private boolean isConformantSizeForProperty(Collection<?> values, EStructuralFeature sf) throws EolIllegalPropertyException {
        int size = values.size();
        int lowerbound = sf.getLowerBound();
        int upperbound = sf.getUpperBound();
        if (upperbound == -1) {
            upperbound = Integer.MAX_VALUE;
        }
        return lowerbound <= size && size <= upperbound;
    }

    private boolean allAreConformantTypeForProperty(Collection<?> values, EStructuralFeature sf) throws EolIllegalPropertyException {
        EClassifier eType = sf.getEType();
        for (Object value : values) {
            if (eType.isInstance(value)) continue;
            return false;
        }
        return true;
    }
}

