/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.emf;

import java.util.HashMap;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.common.util.StringUtil;
import org.eclipse.epsilon.eol.m3.Attribute;
import org.eclipse.epsilon.eol.m3.MetaClass;
import org.eclipse.epsilon.eol.m3.Metamodel;
import org.eclipse.epsilon.eol.m3.Reference;
import org.eclipse.epsilon.eol.models.IRelativePathResolver;
import org.eclipse.epsilon.eol.types.EolAnyType;
import org.eclipse.epsilon.eol.types.EolModelElementType;
import org.eclipse.epsilon.eol.types.EolPrimitiveType;
import org.eclipse.epsilon.eol.types.EolType;

public class EmfModelMetamodel
extends Metamodel {
    public EmfModelMetamodel(StringProperties properties, IRelativePathResolver resolver) {
        HashMap<EClass, MetaClass> eClassMetaClassMap = new HashMap<EClass, MetaClass>();
        String nsuri = properties.getProperty("nsuri");
        if (nsuri == null) {
            this.getErrors().add("Required property nsuri not found");
        } else {
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(nsuri);
            if (ePackage == null) {
                this.getErrors().add("EPackage with nsURI " + nsuri + " is not available in EPackage.Registry.INSTANCE");
            } else {
                MetaClass metaClass;
                for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                    if (!(eClassifier instanceof EClass)) continue;
                    metaClass = new MetaClass();
                    metaClass.setName(eClassifier.getName());
                    eClassMetaClassMap.put((EClass)eClassifier, metaClass);
                    this.metaTypes.add(metaClass);
                }
                for (EClass eClass : eClassMetaClassMap.keySet()) {
                    metaClass = (MetaClass)eClassMetaClassMap.get(eClass);
                    for (EClass eSuperType : eClass.getESuperTypes()) {
                        MetaClass superType = (MetaClass)eClassMetaClassMap.get(eSuperType);
                        if (superType == null) continue;
                        metaClass.getSuperTypes().add(superType);
                    }
                    for (EAttribute eAttribute : eClass.getEAttributes()) {
                        Attribute attribute = new Attribute();
                        attribute.setName(eAttribute.getName());
                        attribute.setOrdered(eAttribute.isOrdered());
                        attribute.setUnique(eAttribute.isUnique());
                        attribute.setMany(eAttribute.isMany());
                        String instanceClassName = eAttribute.getEAttributeType().getInstanceClassName();
                        if (StringUtil.isOneOf((String)instanceClassName, (String[])new String[]{String.class.getCanonicalName(), "String"})) {
                            attribute.setType((EolType)EolPrimitiveType.String);
                        } else if (StringUtil.isOneOf((String)instanceClassName, (String[])new String[]{Integer.class.getCanonicalName(), "int"})) {
                            attribute.setType((EolType)EolPrimitiveType.Integer);
                        } else if (StringUtil.isOneOf((String)instanceClassName, (String[])new String[]{Boolean.class.getCanonicalName(), "boolean"})) {
                            attribute.setType((EolType)EolPrimitiveType.Boolean);
                        } else if (instanceClassName != null && (instanceClassName.equals(Float.class.getCanonicalName()) || instanceClassName.equals(Double.class.getCanonicalName()))) {
                            attribute.setType((EolType)EolPrimitiveType.Real);
                        } else {
                            attribute.setType((EolType)EolAnyType.Instance);
                        }
                        metaClass.getStructuralFeatures().add(attribute);
                    }
                    for (EReference eReference : eClass.getEReferences()) {
                        Reference reference = new Reference();
                        reference.setName(eReference.getName());
                        reference.setOrdered(eReference.isOrdered());
                        reference.setUnique(eReference.isUnique());
                        reference.setMany(eReference.isMany());
                        reference.setContainment(eReference.isContainment());
                        EClass referenceType = eReference.getEReferenceType();
                        MetaClass referenceMetaClass = (MetaClass)eClassMetaClassMap.get(referenceType);
                        if (referenceMetaClass != null) {
                            reference.setType((EolType)new EolModelElementType(referenceMetaClass));
                        }
                        metaClass.getStructuralFeatures().add(reference);
                    }
                }
            }
        }
    }
}

