/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.emf;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.epsilon.emc.emf.EmfModel;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;

public final class EmfModelFactory {
    private static final EmfModelFactory instance = new EmfModelFactory();

    private EmfModelFactory() {
    }

    public static EmfModelFactory getInstance() {
        return instance;
    }

    public EmfModel createEmfModel(String name, File model, Object metamodel) {
        EmfModel emfModel = this.createEmfModel(name, model);
        if (metamodel instanceof String) {
            emfModel.setMetamodelUri((String)metamodel);
        } else if (metamodel instanceof EPackage) {
            emfModel.setMetamodelUri(((EPackage)metamodel).getNsURI());
        } else if (metamodel instanceof EPackage[]) {
            EPackage[] arr = (EPackage[])metamodel;
            ArrayList<String> nsUris = new ArrayList<String>(arr.length);
            EPackage[] ePackageArray = arr;
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                EPackage p = ePackageArray[n2];
                nsUris.add(p.getNsURI());
                ++n2;
            }
            emfModel.setMetamodelUris(nsUris);
        } else if (metamodel instanceof File) {
            emfModel.setMetamodelFile(((File)metamodel).getAbsolutePath());
        } else if (metamodel instanceof File[]) {
            File[] arr = (File[])metamodel;
            ArrayList<String> files = new ArrayList<String>(arr.length);
            File[] fileArray = arr;
            int n = arr.length;
            int n3 = 0;
            while (n3 < n) {
                File f = fileArray[n3];
                files.add(f.getAbsolutePath());
                ++n3;
            }
            emfModel.setMetamodelFiles(files);
        } else if (metamodel instanceof URI) {
            emfModel.setMetamodelFileUri((URI)metamodel);
        } else {
            throw new IllegalArgumentException("Not a recognised metamodel type: " + metamodel.getClass().getCanonicalName());
        }
        return emfModel;
    }

    public EmfModel createEmfModel(String name, File model, Object metamodel, AccessMode accessMode) {
        EmfModel emfModel = this.createEmfModel(name, model, metamodel);
        accessMode.applyTo(emfModel);
        return emfModel;
    }

    public EmfModel loadEmfModel(String name, File model, Object metamodel) throws EolModelLoadingException {
        EmfModel emfModel = this.createEmfModel(name, model, metamodel);
        emfModel.load();
        return emfModel;
    }

    public EmfModel loadEmfModel(String name, File model, Object metamodel, AccessMode accessMode) throws EolModelLoadingException {
        EmfModel emfModel = this.createEmfModel(name, model, metamodel, accessMode);
        emfModel.load();
        return emfModel;
    }

    private EmfModel createEmfModel(String name, File model) {
        EmfModel emfModel = new EmfModel();
        emfModel.setName(name);
        emfModel.setModelFile(model.getAbsolutePath());
        return emfModel;
    }

    public static enum AccessMode {
        READ_ONLY(true, false),
        WRITE_ONLY(false, true),
        READ_WRITE(true, true);

        private final boolean readOnLoad;
        private final boolean storedOnDisposal;

        private AccessMode(boolean readOnLoad, boolean storedOnDisposal) {
            this.readOnLoad = readOnLoad;
            this.storedOnDisposal = storedOnDisposal;
        }

        public void applyTo(EmfModel model) {
            model.setReadOnLoad(this.readOnLoad);
            model.setStoredOnDisposal(this.storedOnDisposal);
        }
    }
}

