/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.emf;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public class CachedResourceSet
extends ResourceSetImpl {
    protected static final Cache cache = new Cache();

    public static Cache getCache() {
        return cache;
    }

    public Resource createResource(URI uri, String contentType) {
        Resource cachedResource = CachedResourceSet.getCache().checkoutResource(uri);
        if (cachedResource == null) {
            cachedResource = this.createNewResource(uri, contentType);
            cachedResource.setTrackingModification(false);
            if (cachedResource instanceof XMLResource) {
                this.configure((XMLResource)cachedResource);
            }
            this.getResources().add((Object)cachedResource);
            CachedResourceSet.getCache().cacheResource(uri, cachedResource);
        }
        return cachedResource;
    }

    public Resource createNewResource(URI uri, String contentType) {
        Resource resource = super.createResource(uri, contentType);
        if (resource == null) {
            resource = new XMIResourceFactoryImpl().createResource(uri);
        }
        return resource;
    }

    public void configure(XMLResource resource) {
        Map loadOptions = resource.getDefaultLoadOptions();
        loadOptions.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        loadOptions.put("LAX_FEATURE_PROCESSING", Boolean.TRUE);
        loadOptions.put("PROCESS_DANGLING_HREF", "DISCARD");
    }

    public static class Cache {
        protected Collection<CacheItem> items = new ConcurrentLinkedQueue<CacheItem>();

        public void cacheResource(URI uri, Resource resource) {
            CacheItem item = new CacheItem();
            item.setUri(uri);
            item.setResource(resource);
            item.incrementCheckedOut();
            this.items.add(item);
        }

        public boolean isCached(URI uri) {
            for (CacheItem item : this.items) {
                if (!item.getUri().equals(uri)) continue;
                return item.getResource() != null;
            }
            return false;
        }

        public Resource checkoutResource(URI uri) {
            CacheItem toCheckout = null;
            for (CacheItem item : this.items) {
                if (!item.getUri().equals(uri)) continue;
                toCheckout = item;
                break;
            }
            if (toCheckout == null) {
                return null;
            }
            if (toCheckout.getResource() != null) {
                toCheckout.incrementCheckedOut();
                return toCheckout.getResource();
            }
            this.items.remove(toCheckout);
            return null;
        }

        public void returnResource(Resource resource) {
            CacheItem toReturn = null;
            for (CacheItem item : this.items) {
                if (!resource.equals(item.getResource())) continue;
                toReturn = item;
                break;
            }
            if (toReturn != null) {
                toReturn.decrementCheckedOut();
                if (toReturn.getCheckedOut() == 0) {
                    this.items.remove(toReturn);
                    resource.unload();
                }
            }
        }

        public void clear() {
            this.items.clear();
        }

        public int size() {
            return this.items.size();
        }

        public Collection<CacheItem> getItems() {
            return this.items;
        }

        public class CacheItem {
            private WeakReference<Resource> resourceReference;
            private URI uri;
            private List<StackTraceElement[]> checkedInFrom = new ArrayList<StackTraceElement[]>();
            private List<StackTraceElement[]> checkedOutFrom = new ArrayList<StackTraceElement[]>();
            private int checkedOutCount = 0;

            public Resource getResource() {
                return (Resource)this.resourceReference.get();
            }

            public void setResource(Resource resource) {
                this.resourceReference = new WeakReference<Resource>(resource);
            }

            public void setUri(URI uri) {
                this.uri = uri;
            }

            public URI getUri() {
                return this.uri;
            }

            public void incrementCheckedOut() {
                this.checkedInFrom.add(Thread.currentThread().getStackTrace());
                ++this.checkedOutCount;
            }

            public void decrementCheckedOut() {
                this.checkedOutFrom.add(Thread.currentThread().getStackTrace());
                --this.checkedOutCount;
            }

            public int getCheckedOut() {
                return this.checkedOutCount;
            }

            public List<StackTraceElement[]> getCheckedInFrom() {
                return this.checkedInFrom;
            }

            public List<StackTraceElement[]> getCheckedOutFrom() {
                return this.checkedOutFrom;
            }
        }
    }
}

