/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.emf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epsilon.emc.emf.AbstractEmfModel;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolNotAnEnumerationValueException;
import org.eclipse.epsilon.eol.execute.introspection.IReflectivePropertySetter;
import org.eclipse.epsilon.eol.models.IReflectiveModel;

public abstract class AbstractReflectiveEmfModel
extends AbstractEmfModel
implements IReflectiveModel {
    public IReflectivePropertySetter getPropertySetter() {
        return (IReflectivePropertySetter)this.propertySetter;
    }

    public Collection<String> getPropertiesOf(String type) throws EolModelElementTypeNotFoundException {
        EList<EStructuralFeature> features = this.featuresForType(type);
        ArrayList<String> properties = new ArrayList<String>(features.size());
        for (EStructuralFeature feature : features) {
            properties.add(feature.getName());
        }
        return properties;
    }

    public boolean preventLoadingOfExternalModelElements() {
        if (this.isExpand()) {
            this.setExpand(false);
            return true;
        }
        return false;
    }

    public boolean hasProperty(String type, String property) throws EolModelElementTypeNotFoundException {
        return this.getPropertiesOf(type).contains(property);
    }

    public boolean isEnumerationValue(Object object) {
        return object instanceof Enumerator;
    }

    public String getEnumerationTypeOf(Object literal) throws EolNotAnEnumerationValueException {
        if (!this.isEnumerationValue(literal)) {
            throw new EolNotAnEnumerationValueException(literal);
        }
        if (literal instanceof EEnumLiteral) {
            return ((EEnumLiteral)literal).getEEnum().getName();
        }
        return ((Enumerator)literal).getClass().getSimpleName();
    }

    public String getEnumerationLabelOf(Object literal) throws EolNotAnEnumerationValueException {
        if (!this.isEnumerationValue(literal)) {
            throw new EolNotAnEnumerationValueException(literal);
        }
        return ((Enumerator)literal).getName();
    }

    public boolean hasPackage(String packageName) {
        return this.packageForName(packageName) != null;
    }

    private EPackage packageForName(String name) {
        EPackage current;
        String[] parts = name.split("::");
        int partIndex = 0;
        EList next = this.getTopLevelPackages();
        do {
            if ((current = AbstractReflectiveEmfModel.packageForName(parts[partIndex++], next)) == null) continue;
            next = current.getESubpackages();
        } while (current != null && partIndex < parts.length);
        return current;
    }

    private Collection<EPackage> getTopLevelPackages() {
        return this.getPackageRegistry().values().stream().filter(pkg -> pkg instanceof EPackage).map(pkg -> (EPackage)pkg).collect(Collectors.toCollection(LinkedList::new));
    }

    private static EPackage packageForName(String name, Collection<EPackage> packages) {
        return packages.stream().filter(pkg -> name.equals(pkg.getName())).findAny().orElse(null);
    }

    private EList<EStructuralFeature> featuresForType(String type) throws EolModelElementTypeNotFoundException {
        return this.classForName(type).getEAllStructuralFeatures();
    }
}

