/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.emf;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.epsilon.common.concurrent.ConcurrencyUtils;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.emc.emf.CachedResourceSet;
import org.eclipse.epsilon.emc.emf.ContainmentChangeAdapter;
import org.eclipse.epsilon.emc.emf.EmfPropertyGetter;
import org.eclipse.epsilon.emc.emf.EmfPropertySetter;
import org.eclipse.epsilon.emc.emf.EmfUtil;
import org.eclipse.epsilon.emc.emf.transactions.EmfModelTransactionSupport;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolEnumerationValueNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.exceptions.models.EolNotInstantiableModelElementTypeException;
import org.eclipse.epsilon.eol.models.CachedModel;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.models.IRelativePathResolver;
import org.eclipse.epsilon.eol.models.ModelRepository;
import org.eclipse.epsilon.eol.models.transactions.IModelTransactionSupport;

public abstract class AbstractEmfModel
extends CachedModel<EObject> {
    public static final String PROPERTY_EXPAND = "expand";
    public static final String PROPERTY_PARALLELALLOF = "parallelAllOf";
    protected Resource modelImpl;
    protected boolean expand = true;
    protected EPackage.Registry registry;
    Map<String, EClass> eClassCache;
    Map<String, Object> enumCache;
    protected Map<Object, Object> resourceLoadOptions = null;
    protected Map<Object, Object> resourceStoreOptions = null;
    boolean parallelAllOf;
    protected EmfModelTransactionSupport transactionSupport;

    public AbstractEmfModel() {
        this.propertyGetter = new EmfPropertyGetter();
        this.propertySetter = new EmfPropertySetter();
    }

    private <K, V> Map<K, V> createMap(Map<K, V> original) {
        if (this.isConcurrent()) {
            return original == null ? ConcurrencyUtils.concurrentMap() : ConcurrencyUtils.concurrentMap(original);
        }
        return original == null ? new HashMap() : new HashMap<K, V>(original);
    }

    protected synchronized void initCaches() {
        super.initCaches();
        this.eClassCache = this.createMap(this.eClassCache);
        this.enumCache = this.createMap(this.enumCache);
    }

    protected InputStream getInputStream(String file) throws IOException {
        if (file.startsWith("bundleresource:") || file.startsWith("platform:")) {
            URL url = new URL(file);
            return url.openConnection().getInputStream();
        }
        return new FileInputStream(file);
    }

    public void addMetamodelUri(String nsUri) {
        this.getPackageRegistry().put((Object)nsUri, EPackage.Registry.INSTANCE.get((Object)nsUri));
    }

    protected EPackage.Registry getPackageRegistry() {
        if (this.registry == null) {
            this.registry = this.modelImpl == null || this.modelImpl.getResourceSet() == null ? EPackage.Registry.INSTANCE : this.modelImpl.getResourceSet().getPackageRegistry();
        }
        return this.registry;
    }

    public Object getEnumerationValue(String enumeration, String label) throws EolEnumerationValueNotFoundException {
        Object value = this.enumCache.computeIfAbsent(String.valueOf(enumeration) + '#' + label, k -> {
            ArrayList<EEnumLiteral> optionLiterals = new ArrayList<EEnumLiteral>();
            ArrayList<Enumerator> optionValues = new ArrayList<Enumerator>();
            ArrayList availablePackages = new ArrayList(this.getPackageRegistry().values());
            for (Object pkg : availablePackages) {
                if (!EmfUtil.isEPackageOrDescriptor(pkg)) continue;
                EPackage ePackage = EmfUtil.toEPackage(pkg);
                for (EClassifier classifier : EmfUtil.getAllEClassifiers(ePackage)) {
                    EEnum eEnum;
                    EEnumLiteral literal;
                    if (!(classifier instanceof EEnum) || !((EEnum)classifier).getName().equals(enumeration) && !this.getFullyQualifiedName(classifier).equals(enumeration) && !"".equals(enumeration) || (literal = (eEnum = (EEnum)classifier).getEEnumLiteral(label)) == null) continue;
                    optionLiterals.add(literal);
                    optionValues.add(literal.getInstance());
                }
            }
            if (optionValues.size() == 1) {
                return optionValues.get(0);
            }
            if (optionValues.isEmpty()) {
                return null;
            }
            List optionNames = optionLiterals.stream().map(l -> String.format("%s!%s#%s", this.getName(), l.getEEnum().getName(), l.getName())).collect(Collectors.toList());
            return new ModelRepository.AmbiguousEnumerationValue(optionNames, (String)optionNames.get(0), optionValues.get(0));
        });
        if (value == null) {
            throw new EolEnumerationValueNotFoundException(enumeration, label, this.getName());
        }
        return value;
    }

    public boolean knowsAboutProperty(Object instance, String property) {
        if (!this.owns(instance)) {
            return false;
        }
        EObject eObject = (EObject)instance;
        return this.knowsAboutProperty(eObject, property);
    }

    protected boolean knowsAboutProperty(EObject instance, String property) {
        return EmfUtil.getEStructuralFeature(instance.eClass(), property) != null;
    }

    public boolean isPropertySet(Object instance, String property) throws EolRuntimeException {
        if (!this.owns(instance)) {
            return false;
        }
        EObject eObject = (EObject)instance;
        EStructuralFeature sf = EmfUtil.getEStructuralFeature(eObject.eClass(), property);
        return eObject.eIsSet(sf);
    }

    Collection<EObject> getAllFromModel(Predicate<EObject> criteria) throws EolModelElementTypeNotFoundException {
        return StreamSupport.stream(this.allContents().spliterator(), this.parallelAllOf).filter(criteria).collect(Collectors.toList());
    }

    protected Collection<EObject> getAllOfTypeFromModel(String type) throws EolModelElementTypeNotFoundException {
        EClass eClass = this.classForName(type);
        return this.getAllFromModel(eObject -> eObject.eClass() == eClass);
    }

    protected Collection<EObject> getAllOfKindFromModel(String kind) throws EolModelElementTypeNotFoundException {
        EClass eClass = this.classForName(kind);
        return this.getAllFromModel(arg_0 -> ((EClass)eClass).isInstance(arg_0));
    }

    public Object getCacheKeyForType(String type) throws EolModelElementTypeNotFoundException {
        return this.classForName(type);
    }

    public EClass classForName(String name) throws EolModelElementTypeNotFoundException {
        if (name != null) {
            EClass eClass = this.eClassCache.get(name);
            if (eClass != null) {
                return eClass;
            }
            eClass = this.classForName(name, this.getPackageRegistry());
            if (eClass != null) {
                this.eClassCache.put(name, eClass);
                return eClass;
            }
        }
        throw new EolModelElementTypeNotFoundException(this.name, name);
    }

    protected EClass classForName(String name, EPackage.Registry registry) {
        return this.classesForName(name, registry).findAny().orElse(null);
    }

    protected Stream<EClass> classesForName(String name, EPackage.Registry registry) {
        boolean absolute = name.contains("::");
        return registry.values().stream().filter(pkg -> pkg instanceof EPackage).map(pkg -> this.classForName(name, absolute, (EPackage)pkg)).filter(eClass -> eClass != null);
    }

    protected EClass classForName(String name, boolean absolute, EPackage pkg) {
        for (EClassifier eClassifier : EmfUtil.getAllEClassifiers(pkg)) {
            String eClassifierName;
            if (!(eClassifier instanceof EClass)) continue;
            String string = eClassifierName = absolute ? this.getFullyQualifiedName(eClassifier) : eClassifier.getName();
            if (!eClassifierName.equals(name)) continue;
            return (EClass)eClassifier;
        }
        return null;
    }

    protected Collection<EObject> allContentsFromModel() {
        LinkedList<EObject> allInstances = new LinkedList<EObject>();
        for (Resource resource : this.getResources()) {
            TreeIterator it = EcoreUtil.getAllContents((Resource)resource, (boolean)this.expand);
            while (it.hasNext()) {
                allInstances.add((EObject)it.next());
            }
        }
        return allInstances;
    }

    protected EObject createInstanceInModel(String type) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        EClass eClass = this.classForName(type);
        if (eClass.isAbstract()) {
            throw new EolNotInstantiableModelElementTypeException(this.name, type);
        }
        EObject instance = eClass.getEPackage().getEFactoryInstance().create(eClass);
        this.modelImpl.getContents().add((Object)instance);
        instance.eAdapters().add((Object)new ContainmentChangeAdapter(instance, this.modelImpl));
        instance.eAllContents().forEachRemaining(descendant -> {
            boolean bl = descendant.eAdapters().add((Object)new ContainmentChangeAdapter((EObject)descendant, this.modelImpl));
        });
        return instance;
    }

    public IModelTransactionSupport getTransactionSupport() {
        if (this.transactionSupport == null) {
            this.transactionSupport = new EmfModelTransactionSupport(this);
        }
        return this.transactionSupport;
    }

    protected boolean deleteElementInModel(Object instance) throws EolRuntimeException {
        if (!(instance instanceof EObject)) {
            return false;
        }
        EObject eObject = (EObject)instance;
        EcoreUtil.delete((EObject)eObject);
        ArrayList contents = new ArrayList(eObject.eContents());
        for (EObject content : contents) {
            this.deleteElement(content);
        }
        contents.clear();
        return true;
    }

    public boolean owns(Object instance) {
        if (instance instanceof EObject) {
            EObject eObject = (EObject)instance;
            Resource eObjectResource = eObject.eResource();
            if (eObjectResource == null) {
                return false;
            }
            if (this.expand) {
                return this.modelImpl.getResourceSet() == eObjectResource.getResourceSet();
            }
            return this.modelImpl == eObjectResource;
        }
        return false;
    }

    public boolean store(String fileName) {
        return this.store(EmfUtil.createPlatformResourceURI(fileName));
    }

    public boolean store(URI uri) {
        this.modelImpl.setURI(uri);
        return this.store();
    }

    public boolean store(OutputStream os) {
        if (this.modelImpl == null) {
            return false;
        }
        try {
            this.modelImpl.save(os, null);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void disposeModel() {
        this.registry = null;
        if (this.modelImpl != null) {
            CachedResourceSet.Cache cache = CachedResourceSet.getCache();
            if (this.modelImpl.getResourceSet() != null) {
                for (Resource r : this.modelImpl.getResourceSet().getResources()) {
                    cache.returnResource(r);
                }
            } else {
                cache.returnResource(this.modelImpl);
            }
            this.modelImpl = null;
        }
        this.eClassCache.clear();
        this.enumCache.clear();
    }

    public Resource getResource() {
        return this.modelImpl;
    }

    public void setResource(Resource resource) {
        this.modelImpl = resource;
    }

    @Deprecated
    public Resource getModelImpl() {
        return this.modelImpl;
    }

    public void setModelImpl(Resource modelImpl) {
        this.modelImpl = modelImpl;
    }

    protected List<Resource> getResources() {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        ResourceSet rs = this.modelImpl.getResourceSet();
        if (this.expand && rs != null) {
            EList rawResources = rs.getResources();
            for (Resource rawResource : rawResources) {
                boolean contained = true;
                for (EObject root : rawResource.getContents()) {
                    EObject container = root.eContainer();
                    if (container != null) continue;
                    contained = false;
                    break;
                }
                if (contained) continue;
                resources.add(rawResource);
            }
        } else {
            resources.add(this.modelImpl);
        }
        return resources;
    }

    public Object getElementById(String id) {
        for (Resource resource : this.getResources()) {
            EObject instance = resource.getEObject(id);
            if (instance == null) continue;
            return instance;
        }
        return null;
    }

    public String getElementId(Object instance) {
        EObject eObject = (EObject)instance;
        return eObject.eResource().getURIFragment(eObject);
    }

    public void setElementId(Object instance, String newId) {
        if (newId == null || newId.isEmpty()) {
            return;
        }
        if (this.isUriFragment(newId)) {
            return;
        }
        EObject eObject = (EObject)instance;
        if (eObject.eResource() instanceof XMIResource) {
            ((XMIResource)eObject.eResource()).setID(eObject, newId);
        }
    }

    private boolean isUriFragment(String newId) {
        return newId.startsWith("/") || newId.startsWith("#/");
    }

    public Object getTypeOf(Object instance) {
        return ((EObject)instance).eClass();
    }

    public String getTypeNameOf(Object instance) {
        if (!this.isModelElement(instance)) {
            throw new IllegalArgumentException("Not a valid EMF model element: " + instance + " (" + instance.getClass().getCanonicalName() + ") ");
        }
        return ((EClass)this.getTypeOf(instance)).getName();
    }

    public String getFullyQualifiedTypeNameOf(Object instance) {
        if (!this.isModelElement(instance)) {
            throw new IllegalArgumentException("Not a valid EMF model element: " + instance + " (" + instance.getClass().getCanonicalName() + ") ");
        }
        return this.getFullyQualifiedName((EClassifier)((EClass)this.getTypeOf(instance)));
    }

    public Collection<String> getAllTypeNamesOf(Object instance) {
        ArrayList<String> allTypeNames = new ArrayList<String>(0);
        if (this.isModelElement(instance)) {
            EClass type = (EClass)this.getTypeOf(instance);
            EList superTypes = type.getEAllSuperTypes();
            allTypeNames.ensureCapacity(1 + superTypes.size());
            allTypeNames.add(this.getFullyQualifiedName((EClassifier)type));
            for (EClass supertype : superTypes) {
                allTypeNames.add(this.getFullyQualifiedName((EClassifier)supertype));
            }
        }
        return allTypeNames;
    }

    public boolean isInstantiable(String type) {
        try {
            return !this.classForName(type).isAbstract();
        }
        catch (EolModelElementTypeNotFoundException e) {
            return false;
        }
    }

    public boolean hasType(String type) {
        block3: {
            try {
                if (!this.eClassCache.containsKey(type)) break block3;
                return true;
            }
            catch (EolModelElementTypeNotFoundException e) {
                return false;
            }
        }
        this.classForName(type);
        return true;
    }

    public IModel.AmbiguityCheckResult checkAmbiguity(String type) {
        List options = this.classesForName(type, this.getPackageRegistry()).collect(Collectors.toCollection(LinkedHashSet::new)).stream().map(ec -> this.getFullyQualifiedName((EClassifier)ec)).collect(Collectors.toList());
        return new IModel.AmbiguityCheckResult((IModel)this, options);
    }

    protected boolean hasAdapter(Class<? extends EContentAdapter> adapterType) {
        return this.modelImpl.eAdapters().stream().anyMatch(adapterType::isInstance);
    }

    protected String getFullyQualifiedName(EClassifier eClassifier) {
        String fullyQualifiedName = eClassifier.getName();
        EPackage parent = eClassifier.getEPackage();
        while (parent != null) {
            fullyQualifiedName = String.valueOf(parent.getName()) + "::" + fullyQualifiedName;
            parent = parent.getESuperPackage();
        }
        return fullyQualifiedName;
    }

    public boolean isModelElement(Object instance) {
        return instance instanceof EObject;
    }

    public boolean isOfKind(Object instance, String metaClass) throws EolModelElementTypeNotFoundException {
        EClass eClass = this.classForName(metaClass);
        return eClass.isInstance(instance);
    }

    public boolean isOfType(Object instance, String metaClass) throws EolModelElementTypeNotFoundException {
        EClass eClass = this.classForName(metaClass);
        if (instance instanceof EObject) {
            EObject eObject = (EObject)instance;
            return eClass == eObject.eClass();
        }
        return false;
    }

    public Object getContainerOf(Object object) {
        if (object instanceof EObject) {
            return ((EObject)object).eContainer();
        }
        return null;
    }

    public void validate() throws EolModelLoadingException {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (this.modelImpl != null) {
            if (this.modelImpl.getResourceSet() != null) {
                resources.addAll((Collection<Resource>)this.modelImpl.getResourceSet().getResources());
            } else {
                resources.add(this.modelImpl);
            }
        }
        for (Resource resource : this.modelImpl.getResourceSet().getResources()) {
            if (!resource.getErrors().isEmpty() || !resource.getWarnings().isEmpty()) {
                ArrayList resourceDiagnostics = new ArrayList();
                resourceDiagnostics.addAll(resource.getErrors());
                resourceDiagnostics.addAll(resource.getWarnings());
                Resource.Diagnostic diagnostic = (Resource.Diagnostic)resourceDiagnostics.get(0);
                throw new EolModelLoadingException(new Exception(String.valueOf(diagnostic.getMessage()) + " (" + diagnostic.getLocation() + "@" + diagnostic.getLine() + ")"), (IModel)this);
            }
            List diagnostics = EmfUtil.validate(resource).getChildren().stream().filter(d -> d.getSeverity() != 1).collect(Collectors.toList());
            if (diagnostics.isEmpty()) continue;
            Diagnostic diagnostic = (Diagnostic)diagnostics.get(0);
            throw new EolModelLoadingException(new Exception(diagnostic.getMessage()), (IModel)this);
        }
    }

    public boolean isExpand() {
        return this.expand;
    }

    public void setExpand(boolean expand) {
        this.expand = expand;
    }

    public void setParallelAllOf(boolean parallel) {
        this.parallelAllOf = parallel;
    }

    public boolean isParallelAllOf() {
        return this.parallelAllOf;
    }

    public void load(StringProperties properties, IRelativePathResolver resolver) throws EolModelLoadingException {
        super.load(properties, resolver);
        this.setParallelAllOf(properties.getBooleanProperty(PROPERTY_PARALLELALLOF, this.parallelAllOf));
        this.setExpand(properties.getBooleanProperty(PROPERTY_EXPAND, this.expand));
    }

    public boolean isLoaded() {
        return this.modelImpl != null && this.modelImpl.isLoaded();
    }

    public Map<Object, Object> getResourceLoadOptions() {
        if (this.resourceLoadOptions == null && this.modelImpl instanceof XMLResource) {
            this.resourceLoadOptions = new HashMap<Object, Object>();
            this.resourceLoadOptions.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        }
        return this.resourceLoadOptions;
    }

    public void setResourceLoadOptions(Map<Object, Object> options) {
        this.resourceLoadOptions = options;
    }

    public Object putResourceLoadOption(Object key, Object value) {
        if (this.getResourceLoadOptions() == null) {
            this.resourceLoadOptions = new HashMap<Object, Object>();
        }
        return this.resourceLoadOptions.put(key, value);
    }

    public Map<Object, Object> getResourceStoreOptions() {
        return this.resourceStoreOptions;
    }

    public void setResourceStoreOptions(Map<Object, Object> options) {
        this.resourceStoreOptions = options;
    }

    public Object putResourceStoreOption(Object key, Object value) {
        if (this.resourceStoreOptions == null) {
            this.resourceStoreOptions = new HashMap<Object, Object>();
        }
        return this.resourceStoreOptions.put(key, value);
    }
}

