/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.util.profiling;

import java.io.Serializable;
import java.time.Duration;

public class ProfileDiagnostic
implements Serializable {
    private static final long serialVersionUID = -1275024406100263604L;
    public final String stageName;
    public final Duration executionTime;
    public final double memoryUsage;
    public final MemoryUnit memoryUnits;

    public ProfileDiagnostic(String stage, Duration execTime, double memory, MemoryUnit units) {
        this.stageName = stage;
        this.executionTime = execTime;
        this.memoryUsage = memory;
        this.memoryUnits = units;
    }

    public ProfileDiagnostic(String stage, long execTimeNanos, long memoryBytes) {
        this(stage, Duration.ofNanos(execTimeNanos), memoryBytes, MemoryUnit.BYTES);
    }

    public static enum MemoryUnit {
        BYTES,
        KB,
        MB,
        GB,
        TB,
        PB,
        EB,
        ZB,
        YB;


        public static double convertFromBytes(MemoryUnit to, long amount) {
            return MemoryUnit.convertUnits(BYTES, to, amount);
        }

        public static double convertUnits(MemoryUnit from, MemoryUnit to, double amount) {
            double result;
            block3: {
                int diff;
                double factor;
                block2: {
                    result = amount;
                    factor = 1024.0;
                    diff = from.compareTo(to);
                    if (diff <= 0) break block2;
                    while (diff != 0) {
                        result *= factor;
                        --diff;
                    }
                    break block3;
                }
                if (diff >= 0) break block3;
                while (diff != 0) {
                    result /= factor;
                    ++diff;
                }
            }
            return result;
        }
    }
}

