/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.util;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;

public class UriUtil {
    private UriUtil() {
    }

    public static URI sanitize(String uriStr) throws IllegalArgumentException {
        return URI.create(Objects.requireNonNull(uriStr).replace('\\', '/').replaceAll(" ", "%20"));
    }

    public static URI resolve(String path, URI ... relativeTo) throws URISyntaxException {
        if (path == null) {
            return null;
        }
        URI uri = UriUtil.sanitize(path = UriUtil.encode(path, false));
        if (uri.isAbsolute()) {
            return uri;
        }
        if (relativeTo != null) {
            URI[] uRIArray = relativeTo;
            int n = relativeTo.length;
            int n2 = 0;
            while (n2 < n) {
                URI parent = uRIArray[n2];
                if (parent != null) {
                    URI resolved;
                    boolean parentIsJar = false;
                    if (parent.toString().startsWith("jar:file:/")) {
                        parentIsJar = true;
                        parent = new URI(parent.toString().replace("jar:file:/", "jar:/"));
                    }
                    if ((resolved = parent.resolve(path)).isAbsolute() && resolved.getScheme() != null) {
                        if (parentIsJar) {
                            resolved = new URI(resolved.toString().replace("jar:/", "jar:file:/"));
                        }
                        return resolved;
                    }
                    return new URI(String.valueOf(parent.toString()) + path);
                }
                ++n2;
            }
        }
        return new URI("file://" + uri);
    }

    public static String encode(String s, boolean isDirectory) {
        s = s.replaceAll(" ", "%20").replaceAll("\\\\", "/");
        if (isDirectory && !s.endsWith("/")) {
            s = String.valueOf(s) + "/";
        }
        return s;
    }

    public static URI fileToUri(File file) throws URISyntaxException {
        String encoded = UriUtil.encode(file.getAbsolutePath(), file.isDirectory());
        return new URI("file://" + (encoded.startsWith("/") ? encoded : String.valueOf('/') + encoded));
    }

    public static String getName(URI uri) {
        if (uri.getPath().contains("/")) {
            return uri.getPath().substring(uri.getPath().lastIndexOf(47) + 1);
        }
        return uri.getPath();
    }
}

