/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.util;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Scanner;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StringUtil {
    public static Collection<String> split(String str, String delimiter) {
        if (str == null) {
            return Collections.emptyList();
        }
        return Stream.of(str.split(delimiter)).map(String::trim).collect(Collectors.toList());
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static Object print(Object o) {
        return o;
    }

    public static String firstToUpper(String str) {
        String result = str.substring(1, str.length());
        result = String.valueOf(str.substring(0, 1).toUpperCase()) + result;
        return result;
    }

    public static String firstToLower(String str) {
        String result = str.substring(1, str.length());
        result = String.valueOf(str.substring(0, 1).toLowerCase()) + result;
        return result;
    }

    public static boolean areEqual(String s1, String s2) {
        return StringUtil.toString(s1).equalsIgnoreCase(StringUtil.toString(s2));
    }

    public static String toString(Object o) {
        return Objects.toString(o, "");
    }

    public static boolean isOneOf(String target, String ... candidates) {
        String[] stringArray = candidates;
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            String candidate = stringArray[n2];
            if (candidate.equals(target)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String escapeHtml(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(string.length());
        boolean lastWasBlankChar = false;
        int len = string.length();
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            if (c == ' ') {
                if (lastWasBlankChar) {
                    lastWasBlankChar = false;
                    sb.append("&nbsp;");
                } else {
                    lastWasBlankChar = true;
                    sb.append(' ');
                }
            } else {
                lastWasBlankChar = false;
                if (c == '\"') {
                    sb.append("&quot;");
                } else if (c == '&') {
                    sb.append("&amp;");
                } else if (c == '<') {
                    sb.append("&lt;");
                } else if (c == '>') {
                    sb.append("&gt;");
                } else if (c == '\n') {
                    sb.append("&lt;br/&gt;");
                } else {
                    int ci = 0xFFFF & c;
                    if (ci < 160) {
                        sb.append(c);
                    } else {
                        sb.append("&#");
                        sb.append(ci);
                        sb.append(';');
                    }
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String reverse(String text) {
        return new StringBuilder(text).reverse().toString();
    }

    public static String concat(String separator, Object[] items) {
        StringBuffer sbuf = new StringBuffer();
        boolean first = true;
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (first) {
                first = false;
            } else {
                sbuf.append(separator);
            }
            sbuf.append("" + o);
            ++n2;
        }
        return sbuf.toString();
    }

    public static String stripHashCodes(Object obj) {
        if (obj != null) {
            return obj.toString().replaceAll("@([0-9a-fA-F]{1,8})", "");
        }
        return null;
    }

    public static String inputStreamToString(InputStream inputStream) {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Scanner s = new Scanner(inputStream).useDelimiter("\\A");){
            String string = s.hasNext() ? s.next() : "";
            return string;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

