/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.eclipse.epsilon.common.util.StringUtil;

public class StringProperties
extends Properties {
    private static final long serialVersionUID = 693863217283819570L;

    public static Builder Builder() {
        return new Builder();
    }

    public StringProperties() {
    }

    public StringProperties(String properties) {
        this.load(properties);
    }

    public void load(String properties) {
        try {
            super.load(new ByteArrayInputStream(properties.getBytes()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            super.store(os, "");
            os.flush();
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String str = os.toString();
        try {
            return str.replaceAll("^#.*(\n|\r)", "").replaceAll("^#.*(\n|\r)", "").trim();
        }
        catch (Exception ex) {
            return str;
        }
    }

    public boolean hasProperty(String key) {
        String property = this.getProperty(key);
        return property != null && !property.isEmpty();
    }

    @Override
    public String getProperty(String key) {
        String value = super.getProperty(key);
        if (value == null && key != null) {
            value = super.getProperty(key.toUpperCase());
        }
        if (value == null && key != null) {
            value = super.getProperty(key.toLowerCase());
        }
        return value == null ? "" : value;
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String value = this.getProperty(key);
        return value.isEmpty() ? defaultValue : value;
    }

    public int getIntegerProperty(String key, int default_) {
        if (this.containsKey(key)) {
            return Integer.parseInt(this.getProperty(key));
        }
        return default_;
    }

    @Override
    public Object put(Object key, Object value) {
        return super.put(key, StringUtil.toString(value));
    }

    @Override
    public void putAll(Map<?, ?> map) {
        if (map instanceof Properties) {
            super.putAll(map);
        } else if (map != null) {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public boolean getBooleanProperty(String key, boolean def) {
        String property = this.getProperty(key);
        if ("true".equalsIgnoreCase(property)) {
            return true;
        }
        if ("false".equalsIgnoreCase(property)) {
            return false;
        }
        return def;
    }

    @Override
    public StringProperties clone() {
        StringProperties clone = new StringProperties();
        clone.load(this.toString());
        return clone;
    }

    public static final class Builder {
        final StringProperties props = new StringProperties();

        Builder() {
        }

        public Builder withProperty(String propertyName, Object propertyValue) {
            this.props.put(propertyName, propertyValue);
            return this;
        }

        public Builder withProperties(Map<?, ?> other) {
            this.props.putAll(other);
            return this;
        }

        public StringProperties build() {
            return this.props;
        }
    }
}

