/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class SizeCachingConcurrentQueue<E>
extends ConcurrentLinkedQueue<E> {
    private static final long serialVersionUID = 5903966144644716311L;
    protected static final Object NULL = new Object();
    protected final AtomicInteger size;
    protected final Consumer<? extends E> offerSuper = object -> super.offer(object);

    protected static final Object replaceWithNull(Object o) {
        return o == null ? NULL : o;
    }

    public static final <T> T convertToNull(Object o) {
        return (T)(o == NULL ? null : o);
    }

    public SizeCachingConcurrentQueue() {
        this.size = new AtomicInteger();
    }

    public SizeCachingConcurrentQueue(Collection<? extends E> initial) {
        super(initial);
        this.size = new AtomicInteger(initial.size());
    }

    @Override
    public E peek() {
        return (E)SizeCachingConcurrentQueue.convertToNull(super.peek());
    }

    @Override
    public E poll() {
        Object res = SizeCachingConcurrentQueue.convertToNull(super.poll());
        this.size.decrementAndGet();
        return (E)res;
    }

    @Override
    public boolean offer(E e) {
        this.offerSuper.accept(SizeCachingConcurrentQueue.replaceWithNull(e));
        return this.size.incrementAndGet() > 0;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean res = false;
        if (c != null && c != this) {
            Collection filtered = c.stream().map(SizeCachingConcurrentQueue::replaceWithNull).collect(Collectors.toList());
            res = super.addAll(filtered);
            this.size.getAndAdd(filtered.size());
        }
        return res;
    }

    @Override
    public boolean remove(Object o) {
        if (super.remove(SizeCachingConcurrentQueue.replaceWithNull(o))) {
            this.size.decrementAndGet();
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public Iterator<E> iterator() {
        return new InternalIter(super.iterator());
    }

    @Override
    public boolean contains(Object o) {
        return super.contains(SizeCachingConcurrentQueue.replaceWithNull(o));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SizeCachingConcurrentQueue)) {
            return false;
        }
        Collection that = (Collection)o;
        if (this.size() != that.size()) {
            return false;
        }
        Iterator<E> thisIter = this.iterator();
        Iterator thatIter = that.iterator();
        while (thisIter.hasNext() && thatIter.hasNext()) {
            if (Objects.equals(thisIter.next(), thatIter.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.size);
    }

    private final class InternalIter
    implements Iterator<E> {
        Iterator<E> delegate;

        InternalIter(Iterator<E> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public E next() {
            return SizeCachingConcurrentQueue.convertToNull(this.delegate.next());
        }

        @Override
        public void remove() {
            this.delegate.remove();
            SizeCachingConcurrentQueue.this.size.decrementAndGet();
        }
    }
}

