/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public enum OperatingSystem {
    WINDOWS,
    UNIX,
    LINUX,
    SOLARIS,
    MAC,
    OTHER;


    public static OperatingSystem getOSFamily() {
        switch (System.getProperty("os.name").substring(0, 3).toLowerCase()) {
            case "win": {
                return WINDOWS;
            }
            case "lin": {
                return LINUX;
            }
            case "uni": {
                return UNIX;
            }
            case "dar": 
            case "ios": 
            case "mac": {
                return MAC;
            }
            case "sol": 
            case "sun": {
                return SOLARIS;
            }
        }
        return OTHER;
    }

    public static boolean isARM64() {
        return "aarch64".equals(System.getProperty("os.arch"));
    }

    public static String getJavaVersion() {
        return String.valueOf(System.getProperty("java.vm.name")) + " " + System.getProperty("java.vm.version");
    }

    public static String getOsNameAndVersion() {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            return osName;
        }
        return String.valueOf(osName) + " " + System.getProperty("os.version");
    }

    public static boolean isMac() {
        return OperatingSystem.getOSFamily() == MAC;
    }

    public static boolean isWindows() {
        return OperatingSystem.getOSFamily() == WINDOWS;
    }

    public static boolean isUnix() {
        return !OperatingSystem.isWindows();
    }

    public static String executeCommand(String ... args) throws IOException {
        Process process = new ProcessBuilder(args).redirectErrorStream(true).start();
        StringBuilder processOutput = new StringBuilder();
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader processOutputReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = processOutputReader.readLine()) != null) {
                processOutput.append(String.valueOf(line) + System.lineSeparator());
            }
            try {
                process.waitFor();
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return processOutput.toString().trim();
    }
}

