/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import org.eclipse.epsilon.common.concurrent.ConcurrencyUtils;

public class Multimap<K, V>
implements Map<K, Collection<V>> {
    protected final Map<K, Collection<V>> storage;
    protected final boolean isConcurrent;
    protected final boolean isReadOptimized;

    public Multimap() {
        this(false, false);
    }

    public Multimap(boolean concurrent) {
        this(concurrent, false);
    }

    public Multimap(boolean concurrent, boolean readOnly) {
        this(concurrent, readOnly, null);
    }

    public Multimap(boolean concurrent, boolean readOnly, Map<K, ? extends Collection<V>> other) {
        this.isConcurrent = concurrent;
        this.isReadOptimized = readOnly;
        this.storage = this.newMapDelegate(other != null ? other : null);
    }

    public Multimap(Multimap<K, V> other) {
        this(Objects.requireNonNull(other).isConcurrent, other.isReadOptimized, other.storage);
    }

    protected final Map<K, Collection<V>> newMapDelegate() {
        return this.newMapDelegate(null);
    }

    protected Map<K, Collection<V>> newMapDelegate(Map<? extends K, ? extends Collection<V>> initial) {
        return this.isConcurrent ? ConcurrencyUtils.concurrentMap(initial) : (initial != null ? new HashMap<K, Collection<V>>(initial) : new HashMap());
    }

    protected final Collection<V> newCollection() {
        return this.newCollection(null);
    }

    protected Collection<V> newCollection(Collection<? extends V> values) {
        if (this.isReadOptimized) {
            return values != null ? new CopyOnWriteArrayList<V>(values) : new CopyOnWriteArrayList();
        }
        return this.isConcurrent ? ConcurrencyUtils.concurrentOrderedCollection(values) : (values != null ? new ArrayList<V>(values) : new LinkedList());
    }

    @Override
    public Collection<V> get(Object key) {
        Collection<V> values = this.storage.get(key);
        return values != null ? Collections.unmodifiableCollection(values) : Collections.emptyList();
    }

    public Collection<V> getMutable(Object key) {
        return this.storage.get(key);
    }

    @Override
    public boolean put(K key, V value) {
        Collection<V> values = this.storage.get(key);
        boolean wasPresent = true;
        if (values == null) {
            wasPresent = false;
            values = this.newCollection();
            this.storage.put(key, values);
        }
        values.add(value);
        return wasPresent;
    }

    public boolean putIfPresent(Object key, V value) {
        Collection<V> values = this.storage.get(key);
        return values != null && values.add(value);
    }

    public boolean putAllIfPresent(K key, Collection<V> values) {
        return this.putAll(key, values, false, false, true);
    }

    @Override
    public boolean remove(Object key, Object value) {
        Collection<V> col = this.storage.get(key);
        return col != null && col.remove(value);
    }

    public boolean removeAll(Object key) {
        Collection<V> values = this.storage.get(key);
        boolean changed = false;
        if (values != null) {
            changed = !values.isEmpty();
            values.clear();
        }
        return changed;
    }

    public boolean removeAll(Object key, Collection<V> values) {
        Collection<V> oldValues = this.storage.get(key);
        return oldValues != null && oldValues.removeAll(values);
    }

    @Override
    public Collection<V> remove(Object key) {
        return this.storage.remove(key);
    }

    @Override
    public void clear() {
        this.storage.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        Collection<V> col = this.storage.get(key);
        return col != null && !col.isEmpty();
    }

    public boolean hasKey(K key) {
        return this.storage.containsKey(key);
    }

    public final boolean putAll(K key, Collection<V> values) {
        return this.putAll(key, values, true);
    }

    public boolean putAll(K key, Collection<V> values, boolean wrap) {
        boolean wasPresent;
        boolean bl = wasPresent = this.storage.containsKey(key) && this.storage.get(key).addAll(values);
        if (!wasPresent) {
            this.put(key, values, wrap);
        }
        return wasPresent;
    }

    public boolean replaceValues(K key, Collection<V> values) {
        return this.putAll(key, values, false, true, true);
    }

    public Collection<V> put(K key, Collection<V> values, boolean wrap) {
        return this.storage.put(key, wrap || values == null ? this.newCollection(values) : values);
    }

    @Override
    public Collection<V> put(K key, Collection<V> values) {
        return this.put(key, values, true);
    }

    protected boolean putAll(K key, Collection<V> values, boolean create, boolean replace, boolean wrap) {
        boolean containsKey;
        Collection<V> existingValues = this.storage.get(key);
        boolean bl = containsKey = existingValues != null;
        if (!containsKey && !create) {
            return false;
        }
        if (containsKey && replace || !containsKey && create) {
            this.storage.put(key, wrap ? this.newCollection(values) : values);
            return true;
        }
        if (containsKey && !replace) {
            return existingValues.addAll(values);
        }
        return false;
    }

    public boolean isThreadSafe() {
        return this.isConcurrent;
    }

    public Stream<V> stream(Object key) {
        Collection<V> colForKey = this.storage.get(key);
        return colForKey != null ? colForKey.stream() : Stream.empty();
    }

    public Stream<V> streamAll() {
        return this.storage.values().stream().flatMap(Collection::stream);
    }

    @Override
    public Set<Map.Entry<K, Collection<V>>> entrySet() {
        return Collections.unmodifiableSet(this.storage.entrySet());
    }

    @Override
    public int size() {
        return this.storage.size();
    }

    public int size(K key) {
        Collection<V> values = this.storage.get(key);
        return values != null ? values.size() : -1;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Multimap)) {
            return false;
        }
        Multimap other = (Multimap)obj;
        return this.storage.equals(other.storage);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.storage);
    }

    public String toString() {
        return this.storage.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.storage.containsValue(value) || this.streamAll().anyMatch(v -> Objects.equals(v, value));
    }

    @Override
    public void putAll(Map<? extends K, ? extends Collection<V>> m) {
        this.storage.putAll(m);
    }

    @Override
    public Set<K> keySet() {
        return this.storage.keySet();
    }

    @Override
    public Collection<Collection<V>> values() {
        return this.storage.values();
    }
}

