/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.channels.FileChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.epsilon.common.util.StringUtil;

public class FileUtil {
    private static Path tmpdir;
    private static final boolean isPosix;

    static {
        String javaTemp = System.getProperty("java.io.tmpdir");
        try {
            tmpdir = Paths.get(javaTemp, "epsilon");
            Files.createDirectory(tmpdir, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (Exception ex) {
            System.err.println("Couldn't create temp directory for Epsilon, using default");
            ex.printStackTrace();
            tmpdir = Paths.get(javaTemp, new String[0]);
        }
        isPosix = FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
    }

    private FileUtil() {
    }

    public static Path getCurrentDirectory() {
        return Paths.get(".", new String[0]).toAbsolutePath().normalize();
    }

    public static void setFileContents(String str, File file) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileWriter writer = new FileWriter(file);){
            writer.append(str);
            writer.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String replaceExtension(String filename, String newExtension) {
        int dotIndex = filename.lastIndexOf(46);
        if (dotIndex > -1) {
            filename = String.valueOf(filename.substring(0, dotIndex + 1)) + newExtension;
        }
        return filename;
    }

    public static String removeExtension(String filename) {
        int dotIndex = filename.lastIndexOf(46);
        if (dotIndex > -1) {
            filename = filename.substring(0, dotIndex);
        }
        return filename;
    }

    public static String getFileName(String path) {
        return FileUtil.getFileName(path, true);
    }

    public static String getFileName(String path, boolean includeExtension) {
        String filename = path.substring(path.replace("\\", "/").lastIndexOf(47) + 1);
        if (!includeExtension) {
            filename = FileUtil.removeExtension(filename);
        }
        return filename;
    }

    public static String getExtension(String filename) {
        String extension = "";
        int dotIndex = filename.lastIndexOf(46);
        if (dotIndex > Math.max(filename.lastIndexOf(47), filename.lastIndexOf(92))) {
            extension = filename.substring(dotIndex + 1);
        }
        return extension;
    }

    public static String getFileContents(File file) throws Exception {
        StringBuffer buffer = new StringBuffer();
        String lineSeparator = System.getProperty("line.separator");
        for (String line : FileUtil.getFileLineContents(file)) {
            buffer.append(line);
            buffer.append(lineSeparator);
        }
        return buffer.toString();
    }

    public static Collection<String> getFileLineContents(File file) throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            LinkedList<String> lines = new LinkedList<String>();
            String line = bufferedReader.readLine();
            while (line != null) {
                lines.add(line);
                line = bufferedReader.readLine();
            }
            return lines;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String getAbsolutePath(String basePath, String relativePath) {
        File file = new File(relativePath);
        if (!file.isAbsolute()) {
            file = new File(basePath, relativePath);
        }
        return file.getAbsolutePath();
    }

    public static boolean isInJarFile() {
        return FileUtil.isInJarFile(FileUtil.class);
    }

    public static boolean isInJarFile(Class<?> clazz) {
        return new File(clazz.getProtectionDomain().getCodeSource().getLocation().getPath()).isFile();
    }

    public static Path getStandalonePath(String dir, Class<?> relativeTo) throws IOException {
        URI uri;
        try {
            uri = relativeTo.getResource("").toURI();
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
        return Paths.get(uri).resolve(Paths.get(dir, new String[0]));
    }

    public static File getDirectoryStandalone(String dir, Class<?> relativeTo) throws IOException {
        Objects.requireNonNull(dir, "Directory can't be null!");
        Objects.requireNonNull(relativeTo, "relativeTo (Class) can't be null!");
        dir = dir.replace('\\', '/');
        if (dir.endsWith("/")) {
            dir = dir.substring(0, dir.length() - 1);
        }
        String normalDir = dir;
        Path resource = FileUtil.getStandalonePath(normalDir, relativeTo);
        Collection fileNames = Files.walk(resource, new FileVisitOption[0]).map(p -> {
            String pathStr = p.toString().replace('\\', '/');
            pathStr = pathStr.substring(pathStr.indexOf(normalDir));
            return pathStr;
        }).collect(Collectors.toList());
        for (String fileName : fileNames) {
            FileUtil.getFileStandalone(fileName, relativeTo);
        }
        return FileUtil.getFileStandalone(normalDir, relativeTo);
    }

    public static File getFileStandalone(String name, Class<?> relativeTo) throws IOException {
        if (StringUtil.isEmpty(name)) {
            return tmpdir.toFile();
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream inStream = Objects.requireNonNull(relativeTo, "Class can't be null!").getResourceAsStream(name);){
            return FileUtil.inputStreamToFile(inStream, name);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static File getFileURL(String name, Class<?> relativeTo) {
        try {
            File clazz = new File(URLDecoder.decode(relativeTo.getResource(String.valueOf(relativeTo.getSimpleName()) + ".class").getFile(), "UTF-8"));
            return new File(clazz.getParentFile(), name);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(String.valueOf(name) + " could not be located relative to " + relativeTo);
        }
    }

    public static File getDirectoryOf(Class<?> clazz) throws IOException {
        return FileUtil.getFileURL(String.valueOf(clazz.getSimpleName()) + ".class", clazz).getParentFile();
    }

    public static String getPath(String name, Class<?> relativeTo) throws IOException {
        return FileUtil.getFileURL(name, relativeTo).getAbsolutePath();
    }

    public static void checkFileExists(File file) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException("File " + file.getPath() + " does not exist");
        }
    }

    public static File copyToTemp(File srcFile) throws IOException {
        File tmpFile = File.createTempFile("filecompare", "tmp");
        if (srcFile.isDirectory()) {
            tmpFile.delete();
            tmpFile.mkdir();
        }
        FileUtil.copy(srcFile, tmpFile);
        return tmpFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copy(File srcFile, File dstFile) throws IOException {
        if (srcFile.isDirectory()) {
            dstFile.mkdir();
            File[] fileArray = srcFile.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return;
                }
                File entry = fileArray[n2];
                FileUtil.copy(entry, new File(dstFile, entry.getName()));
                ++n2;
            }
        }
        Throwable throwable = null;
        Object var3_7 = null;
        try {
            FileInputStream isSrc = new FileInputStream(srcFile);
            try {
                block28: {
                    FileOutputStream osDst = new FileOutputStream(dstFile);
                    try {
                        block27: {
                            FileChannel chSrc = isSrc.getChannel();
                            try {
                                try (FileChannel chDst = osDst.getChannel();){
                                    long srcBytes = srcFile.length();
                                    long transferred = 0L;
                                    while (transferred < srcBytes) {
                                        transferred += chDst.transferFrom(chSrc, transferred, srcBytes);
                                        chDst.position(transferred);
                                    }
                                }
                                if (chSrc == null) break block27;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (chSrc == null) throw throwable;
                                chSrc.close();
                                throw throwable;
                            }
                            chSrc.close();
                        }
                        if (osDst == null) break block28;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (osDst == null) throw throwable;
                        osDst.close();
                        throw throwable;
                    }
                    osDst.close();
                }
                if (isSrc == null) return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                if (isSrc == null) throw throwable;
                isSrc.close();
                throw throwable;
            }
            isSrc.close();
            return;
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            }
            if (throwable == throwable5) throw throwable;
            throwable.addSuppressed(throwable5);
            throw throwable;
        }
    }

    public static Set<String> listFilesAsSet(File fileExpected) {
        return new HashSet<String>(Arrays.asList(fileExpected.list()));
    }

    /*
     * Exception decompiling
     */
    public static boolean sameContents(File fileExpected, File fileActual, Set<String> ignoreFilenames, boolean ignoreLineEndings) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 18[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean sameContents(File fileExpected, File fileActual, Set<String> ignoreFilenames) throws IOException {
        return FileUtil.sameContents(fileExpected, fileActual, ignoreFilenames, false);
    }

    public static boolean sameContents(InputStream isExpected, InputStream isActual) throws IOException {
        int chActual;
        int chExpected;
        while ((chExpected = isExpected.read()) == (chActual = isActual.read()) && chExpected > 0 && chActual > 0) {
        }
        return chExpected == chActual;
    }

    public static Path stringToPath(String dir) {
        Path path;
        try {
            path = Paths.get(dir, new String[0]);
        }
        catch (InvalidPathException ipx) {
            path = Paths.get(URI.create(dir));
        }
        return path;
    }

    public static void deleteDirectory(String dir) throws IOException {
        FileUtil.deleteDirectory(FileUtil.stringToPath(dir));
    }

    public static void deleteDirectory(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            Files.walk(path, new FileVisitOption[0]).map(Path::toFile).sorted((o1, o2) -> -o1.compareTo((File)o2)).forEach(File::delete);
        }
    }

    public static Map<Path, byte[]> readDirectory(String dir) throws IOException {
        return FileUtil.readDirectory(FileUtil.stringToPath(dir));
    }

    public static Map<Path, byte[]> readDirectory(Path dir) throws IOException {
        HashMap<Path, byte[]> contents = new HashMap<Path, byte[]>();
        Throwable throwable = null;
        Object var3_4 = null;
        try (Stream<Path> pathStream = Files.walk(dir, new FileVisitOption[0]);){
            Iterator itPaths = pathStream.iterator();
            while (itPaths.hasNext()) {
                Path path = (Path)itPaths.next();
                if (!Files.isRegularFile(path, new LinkOption[0])) continue;
                contents.put(path, Files.readAllBytes(path));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return contents;
    }

    public static File createTempFile(String name) {
        return FileUtil.createTempFile(name, "tmp");
    }

    public static File createTempFile(String name, String extension) {
        Path tmpFile;
        try {
            tmpFile = FileUtil.createTempFile(null, name, extension, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not create temp file ", e);
        }
        return tmpFile.toFile();
    }

    public static File createTempDir(String name) {
        return FileUtil.createTempDir(name, false);
    }

    public static File createTempDir(String name, boolean reuse) {
        Path tmpFile = null;
        if (reuse) {
            DirectoryStream.Filter<Path> filter = file -> Files.isDirectory(file, new LinkOption[0]) && file.getFileName().startsWith(Paths.get(name, new String[0]));
            try {
                Iterator<Path> it = Files.newDirectoryStream(tmpdir, filter).iterator();
                tmpFile = it.hasNext() ? it.next() : null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (tmpFile == null) {
            try {
                tmpFile = FileUtil.createTempDirectory(null, name, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not create temp directory ", e);
            }
        }
        return tmpFile.toFile();
    }

    private static File inputStreamToFile(InputStream inputStream, String name) throws IOException {
        String[] parts;
        boolean isFile;
        String prefix = name = name.replace('\\', '/').replace("../", "");
        String suffix = "";
        Path dirStructure = null;
        if (name.contains("/")) {
            dirStructure = Paths.get(tmpdir.toString(), name.substring(0, name.lastIndexOf("/")), "/");
            dirStructure.toFile().mkdirs();
            name = name.substring(name.lastIndexOf("/") + 1);
        }
        boolean bl = isFile = (parts = name.split("\\.")).length == 2;
        if (isFile) {
            prefix = parts[0];
            suffix = "." + parts[1];
        } else {
            prefix = prefix.substring(prefix.lastIndexOf(47) + 1);
        }
        File file = null;
        Path tempPath = isFile ? FileUtil.createTempFile(dirStructure, prefix, suffix, new FileAttribute[0]) : FileUtil.createTempDirectory(dirStructure, prefix, new FileAttribute[0]);
        file = tempPath.toFile();
        if (file.exists() && file.isDirectory()) {
            return file;
        }
        if (inputStream != null) {
            Throwable throwable = null;
            Object var10_12 = null;
            try (FileOutputStream outputStream = new FileOutputStream(file);){
                byte[] bytes = new byte[1024];
                int read = 0;
                while ((read = inputStream.read(bytes)) != -1) {
                    ((OutputStream)outputStream).write(bytes, 0, read);
                }
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    try {
                        Files.delete(tempPath);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return file;
    }

    static Path createTempDirectory(Path dir, String prefix, FileAttribute<?> ... attrs) throws IOException {
        return FileUtil.create(dir, prefix, null, true, attrs);
    }

    static Path createTempFile(Path dir, String prefix, String suffix, FileAttribute<?> ... attrs) throws IOException {
        return FileUtil.create(dir, prefix, suffix, false, attrs);
    }

    private static Path create(Path dir, String prefix, String suffix, boolean createDirectory, FileAttribute<?>[] attrs) throws IOException {
        Path f;
        if (prefix == null) {
            prefix = "";
        }
        if (suffix == null) {
            String string = suffix = createDirectory ? "" : ".tmp";
        }
        if (dir == null) {
            dir = tmpdir;
        }
        if (isPosix && dir.getFileSystem() == FileSystems.getDefault()) {
            if (attrs.length == 0) {
                attrs = new FileAttribute[]{createDirectory ? PosixPermissions.dirPermissions : PosixPermissions.filePermissions};
            } else {
                boolean hasPermissions = false;
                FileAttribute<?>[] fileAttributeArray = attrs;
                int n = attrs.length;
                int n2 = 0;
                while (n2 < n) {
                    FileAttribute<?> attr = fileAttributeArray[n2];
                    if ("posix:permissions".equals(attr.name())) {
                        hasPermissions = true;
                        break;
                    }
                    ++n2;
                }
                if (!hasPermissions) {
                    FileAttribute[] copy = new FileAttribute[attrs.length + 1];
                    System.arraycopy(attrs, 0, copy, 0, attrs.length);
                    attrs = copy;
                    attrs[attrs.length - 1] = createDirectory ? PosixPermissions.dirPermissions : PosixPermissions.filePermissions;
                }
            }
        }
        SecurityManager sm = System.getSecurityManager();
        try {
            f = FileUtil.generatePath(prefix, suffix, dir);
        }
        catch (InvalidPathException e) {
            if (sm != null) {
                throw new IllegalArgumentException("Invalid prefix or suffix");
            }
            throw e;
        }
        try {
            return createDirectory ? Files.createDirectory(f, attrs) : Files.createFile(f, attrs);
        }
        catch (FileAlreadyExistsException fax) {
            return f;
        }
    }

    private static Path generatePath(String prefix, String suffix, Path dir) {
        Path name = dir.getFileSystem().getPath(String.valueOf(prefix) + suffix, new String[0]);
        if (name.getParent() != null && !StringUtil.isEmpty(suffix)) {
            throw new IllegalArgumentException("Invalid prefix or suffix");
        }
        return dir.resolve(name);
    }

    private static class PosixPermissions {
        static final FileAttribute<Set<PosixFilePermission>> filePermissions = PosixFilePermissions.asFileAttribute(EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE));
        static final FileAttribute<Set<PosixFilePermission>> dirPermissions = PosixFilePermissions.asFileAttribute(EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE));

        private PosixPermissions() {
        }
    }
}

