/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CollectionUtil {
    private CollectionUtil() {
    }

    public static Iterator<?> asIterator(Object o) {
        if (o instanceof Iterator) {
            return (Iterator)o;
        }
        if (o instanceof Iterable) {
            return ((Iterable)o).iterator();
        }
        return Collections.singleton(o).iterator();
    }

    public static boolean equalsIgnoreOrder(Collection<?> c1, Collection<?> c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.size() == c2.size() && c1.containsAll(c2);
    }

    @SafeVarargs
    public static <T> ArrayList<T> composeArrayListFrom(Collection<T> ... collections) {
        int size = 0;
        Collection<T>[] collectionArray = collections;
        int n = collections.length;
        int n2 = 0;
        while (n2 < n) {
            Collection<T> col = collectionArray[n2];
            size += col.size();
            ++n2;
        }
        ArrayList<T> list = new ArrayList<T>(size);
        Collection<T>[] collectionArray2 = collections;
        int n3 = collections.length;
        n = 0;
        while (n < n3) {
            Collection<T> col = collectionArray2[n];
            list.addAll(col);
            ++n;
        }
        return list;
    }

    public static <T, C extends Collection<T>> C mergeCollectionsUnique(Collection<T> c1, Collection<T> c2, Supplier<? extends C> newCollection) {
        Stream<T> stream = c2 != null && (c1 == null || c1.isEmpty()) ? c2.stream() : (c1 != null && (c2 == null || c2.isEmpty()) ? c1.stream() : (c1 != null && c2 != null ? Stream.concat(c1.stream(), c2.stream()) : Stream.empty()));
        return (C)((Collection)stream.distinct().collect(Collectors.toCollection(newCollection)));
    }

    public static void addCapacityIfArrayList(Collection<?> collection, int additionalCapacity) {
        if (collection instanceof ArrayList) {
            ((ArrayList)collection).ensureCapacity(collection.size() + additionalCapacity);
        }
    }

    public static <T> Collection<T> asCollection(T o) {
        if (o instanceof Collection) {
            return (Collection)o;
        }
        ArrayList<T> list = new ArrayList<T>(1);
        list.add(o);
        return list;
    }

    public static <T> List<T> asList(T o) {
        if (o instanceof List) {
            return (List)o;
        }
        List<T> list = CollectionUtil.createDefaultList();
        if (o instanceof Collection) {
            list.addAll((Collection)o);
        } else {
            list.add(o);
        }
        return list;
    }

    public static <T> Set<T> asSet(T o) {
        if (o instanceof Set) {
            return (Set)o;
        }
        Set<T> set = CollectionUtil.createDefaultSet();
        if (o instanceof Collection) {
            set.addAll((Collection)o);
        } else {
            set.add(o);
        }
        return set;
    }

    public static <T> Collection<T> flatten(Collection<T> original) {
        boolean hasNested = false;
        for (T o : original) {
            if (!(o instanceof Collection)) continue;
            hasNested = true;
            break;
        }
        if (!hasNested) {
            return original;
        }
        List<T> flattened = CollectionUtil.createDefaultList();
        for (T next : original) {
            if (next instanceof Collection) {
                flattened.addAll(CollectionUtil.flatten((Collection)next));
                continue;
            }
            flattened.add(next);
        }
        return flattened;
    }

    public static <T> Set<T> createDefaultSet() {
        return new LinkedHashSet();
    }

    public static <T> List<T> createDefaultList() {
        return new ArrayList();
    }

    public static <T> List<T> asList(Collection<T> c) {
        return c instanceof List ? (List<Object>)c : new ArrayList<T>(c);
    }

    public static <T> Object getFirst(Iterable<T> c) {
        Iterator<T> it = c.iterator();
        return it.hasNext() ? it.next() : null;
    }

    public static <T> List<T> iterate(Iterable<T> iterable) {
        List<T> filled = CollectionUtil.createDefaultList();
        Iterator<T> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            filled.add(iterator.next());
        }
        return filled;
    }

    public static <E> E[] toArray(Collection<E> c, Class<?> arrayType) {
        if (c == null) {
            return null;
        }
        Object[] arr = (Object[])Array.newInstance(arrayType, c.size());
        Iterator<E> it = c.iterator();
        int i = 0;
        while (it.hasNext()) {
            arr[i] = it.next();
            ++i;
        }
        return arr;
    }

    public static String join(Iterable<?> collection, String delimiter) {
        return CollectionUtil.join(collection, delimiter, Object::toString);
    }

    public static String join(Iterable<?> collection, String delimiter, ElementPrinter printer) {
        StringBuilder result = new StringBuilder();
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            result.append(printer.print(next));
            if (!iterator.hasNext()) continue;
            result.append(delimiter);
        }
        return result.toString();
    }

    public static interface ElementPrinter {
        public String print(Object var1);
    }
}

