/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epsilon.common.parse.AST;

public class AstUtil {
    public static int getChildrenCount(AST parent) {
        int count = 0;
        if (parent == null) {
            return count;
        }
        AST child = parent.getFirstChild();
        while (child != null) {
            ++count;
            child = child.getNextSibling();
        }
        return count;
    }

    public static AST getChildAt(AST parent, int index) {
        if (parent == null) {
            return null;
        }
        int count = 0;
        AST child = parent.getFirstChild();
        while (child != null) {
            if (count == index) {
                return child;
            }
            child = child.getNextSibling();
            ++count;
        }
        return null;
    }

    public static List<AST> getChildren(AST parent) {
        return AstUtil.getChildren(parent, -1);
    }

    public static List<AST> getChildrenBut(AST parent, int type) {
        ArrayList<AST> children = new ArrayList<AST>();
        if (parent == null) {
            return children;
        }
        AST child = parent.getFirstChild();
        while (child != null) {
            if (child.getType() != type) {
                children.add(child);
            }
            child = child.getNextSibling();
        }
        return children;
    }

    public static List<AST> getChildren(AST parent, int ... types) {
        ArrayList<AST> children = new ArrayList<AST>();
        if (parent == null || types == null || types.length == 0) {
            return children;
        }
        AST child = parent.getFirstChild();
        while (child != null) {
            int[] nArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                int type = nArray[n2];
                if (type == -1 || child.getType() == type) {
                    children.add(child);
                }
                ++n2;
            }
            child = child.getNextSibling();
        }
        return children;
    }

    public static boolean hasAtMostNChildrenOfTypes(int n, AST parent, int ... types) {
        if (parent == null || types == null || types.length == 0) {
            return true;
        }
        int count = 0;
        AST child = parent.getFirstChild();
        while (child != null) {
            int[] nArray = types;
            int n2 = types.length;
            int n3 = 0;
            while (n3 < n2) {
                int type = nArray[n3];
                if ((type == -1 || child.getType() == type) && ++count > n) {
                    return false;
                }
                ++n3;
            }
            child = child.getNextSibling();
        }
        return count <= n;
    }

    public static AST getChild(AST parent, int type) {
        if (parent == null) {
            return null;
        }
        AST child = parent.getFirstChild();
        while (child != null) {
            if (child.getType() == type) {
                return child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public static AST getFirstConcreteChild(AST parent) {
        if (parent.getLine() > 0) {
            return parent;
        }
        AST child = parent.getFirstChild();
        while (child != null) {
            AST result = AstUtil.getFirstConcreteChild(child);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static int getParentType(AST child) {
        AST parent = child.getParent();
        return parent != null ? parent.getType() : -1;
    }
}

