/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.parse;

import java.io.Serializable;
import java.util.Objects;
import org.eclipse.epsilon.common.parse.Position;

public final class Region
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 7112437532509719424L;
    protected Position start;
    protected Position end;

    public Region() {
        this(0, 0, 0, 0);
    }

    public Region(Position start, Position end) {
        this.start = start;
        this.end = end;
    }

    public Region(int startLine, int startColumn, int endLine, int endColumn) {
        this(new Position(startLine, startColumn), new Position(endLine, endColumn));
    }

    public Position getStart() {
        return this.start;
    }

    public Position getEnd() {
        return this.end;
    }

    public void setStart(Position start) {
        this.start = start;
    }

    public void setEnd(Position end) {
        this.end = end;
    }

    public Region clone() {
        Region clone;
        try {
            clone = (Region)super.clone();
        }
        catch (CloneNotSupportedException cnsx) {
            throw new UnsupportedOperationException(cnsx);
        }
        if (this.start != null) {
            clone.start = this.start.clone();
        }
        if (this.end != null) {
            clone.end = this.end.clone();
        }
        return clone;
    }

    public String toString() {
        return this.start + "-" + this.end;
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Region)) {
            return false;
        }
        Region region = (Region)other;
        return Objects.equals(this.start, region.start) && Objects.equals(this.end, region.end);
    }
}

