/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.parse;

import java.io.Serializable;
import java.util.Objects;

public final class Position
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 6556794941272597738L;
    protected int line;
    protected int column;

    public Position() {
    }

    public Position(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public boolean isBefore(Position position) {
        return this.getLine() < position.getLine() || this.getLine() == position.getLine() && this.getColumn() < position.getColumn();
    }

    public boolean isAfter(Position position) {
        return !this.isBefore(position);
    }

    public String toString() {
        return String.valueOf(this.line) + ":" + this.column;
    }

    protected Position clone() {
        Position clone;
        try {
            clone = (Position)super.clone();
        }
        catch (CloneNotSupportedException cnsx) {
            throw new UnsupportedOperationException(cnsx);
        }
        clone.line = this.line;
        clone.column = this.column;
        return clone;
    }

    public int hashCode() {
        return Objects.hash(this.line, this.column);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Position)) {
            return false;
        }
        Position pos = (Position)other;
        return this.column == pos.column && this.line == pos.line;
    }
}

