/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.parse;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.parse.Position;
import org.eclipse.epsilon.common.parse.Region;

public class AST
extends CommonTree {
    protected URI uri;
    protected Integer line = null;
    protected Integer column = null;
    protected Integer length = null;
    protected Region region;
    protected AST annotations;
    protected boolean imaginary;
    protected boolean extraTokensHidden = false;
    protected List<Token> extraTokens = new ArrayList<Token>();
    protected List<Token> commentTokens = new ArrayList<Token>();
    protected List<AST> descendants = null;
    protected IModule module;
    protected HashMap<String, Object> properties = null;

    public AST() {
    }

    public void build() {
    }

    public AST(CommonTree commontree) {
        super(commontree);
        if (commontree.getChildren() != null) {
            for (Object child : commontree.getChildren()) {
                this.addChild((Tree)((CommonTree)child));
            }
        }
    }

    public AST(Token token, AST real) {
        super(token);
        this.region = real.getRegion();
        this.uri = real.getUri();
        this.module = real.getModule();
    }

    public AST(Token token) {
        super(token);
    }

    public AST(Token token, URI uri) {
        super(token);
        this.uri = uri;
    }

    public AST(Token token, URI uri, IModule module) {
        super(token);
        this.uri = uri;
        this.module = module;
    }

    public IModule getModule() {
        return this.module;
    }

    public void setModule(IModule module) {
        this.module = module;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public AST setAnnotationsAst(AST annotations) {
        this.annotations = annotations;
        return this;
    }

    public AST getAnnotationsAst() {
        return this.annotations;
    }

    public HashMap<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        return this.properties;
    }

    public String getBasename() {
        String uriPath = this.getUri().getPath();
        int lastSlash = uriPath.lastIndexOf("/");
        String filename = lastSlash == -1 ? uriPath : uriPath.substring(lastSlash + 1);
        return filename;
    }

    public File getFile() {
        if (this.uri != null && "file".equals(this.uri.getScheme())) {
            return new File(this.uri);
        }
        return null;
    }

    public URI getUri() {
        return this.uri;
    }

    private AST cast(Tree tree) {
        if (tree instanceof AST) {
            return (AST)tree;
        }
        if (tree instanceof CommonTree) {
            return new AST((CommonTree)tree);
        }
        throw new IllegalArgumentException("Cannot cast " + tree.getClass().getSimpleName() + " to AST.");
    }

    public List<AST> getChildren() {
        List children = super.getChildren();
        if (children == null) {
            return Collections.emptyList();
        }
        return children;
    }

    public AST getParent() {
        return (AST)this.parent;
    }

    public AST setLine(int line) {
        this.line = line;
        return this;
    }

    public int getLine() {
        if (this.line == null) {
            return super.getLine();
        }
        return this.line;
    }

    public AST setColumn(int column) {
        this.column = column;
        return this;
    }

    public int getColumn() {
        if (this.column == null) {
            return super.getCharPositionInLine();
        }
        return this.column;
    }

    public AST getNextSibling() {
        if (this.parent == null) {
            return null;
        }
        List siblings = this.parent.getChildren();
        if (this.childIndex >= siblings.size() - 1) {
            return null;
        }
        return this.cast((Tree)siblings.get(this.childIndex + 1));
    }

    public AST setNextSibling(AST sibling) {
        if (this.parent != null && sibling != null) {
            this.parent.getChildren().add(this.childIndex, sibling);
        }
        return this;
    }

    public boolean hasChildren() {
        return this.getChildCount() > 0;
    }

    public AST getChild(int i) {
        return this.cast(super.getChild(i));
    }

    public int getNumberOfChildren() {
        return this.getChildCount();
    }

    public AST getFirstChild() {
        if (this.getChildCount() > 0) {
            return this.cast((Tree)this.getChild(0));
        }
        return null;
    }

    public AST setFirstChild(AST child) {
        if (this.getChildCount() == 0) {
            this.addChild((Tree)child);
        } else {
            this.children.add(0, child);
            this.freshenParentAndChildIndexes();
        }
        return this;
    }

    public AST getSecondChild() {
        if (this.getChildCount() > 1) {
            return this.cast((Tree)this.getChild(1));
        }
        return null;
    }

    public AST getThirdChild() {
        if (this.getChildCount() > 2) {
            return this.cast((Tree)this.getChild(2));
        }
        return null;
    }

    public AST getFourthChild() {
        if (this.getChildCount() > 3) {
            return this.cast((Tree)this.getChild(3));
        }
        return null;
    }

    public AST getLastChild() {
        if (this.getChildCount() > 0) {
            return this.cast((Tree)this.getChild(this.getChildCount() - 1));
        }
        return null;
    }

    public Region getRegion() {
        if (this.region == null) {
            this.region = new Region();
            Position startPosition = new Position();
            if (!this.isImaginary()) {
                startPosition.setLine(this.getLine());
                startPosition.setColumn(this.getColumn());
            } else {
                startPosition.setLine(100000);
                startPosition.setColumn(0);
            }
            this.region.setStart(startPosition);
            Position endPosition = new Position();
            if (!this.isImaginary()) {
                endPosition.setLine(this.getLine());
                endPosition.setColumn(this.getColumn() + this.getLength());
            } else {
                endPosition.setLine(-1);
                endPosition.setColumn(0);
            }
            this.region.setEnd(endPosition);
            for (AST child : this.getChildren()) {
                Region childRegion = child.getRegion();
                if (childRegion.getStart().isBefore(this.region.getStart())) {
                    this.region.setStart(childRegion.getStart());
                }
                if (!childRegion.getEnd().isAfter(this.region.getEnd())) continue;
                this.region.setEnd(childRegion.getEnd());
            }
            if (!this.areExtraTokensHidden()) {
                for (Token token : this.getExtraTokens()) {
                    if (token == null) continue;
                    Position tokenStartPosition = new Position();
                    tokenStartPosition.setLine(token.getLine());
                    tokenStartPosition.setColumn(token.getCharPositionInLine());
                    Position tokenEndPosition = new Position();
                    tokenEndPosition.setLine(token.getLine());
                    tokenEndPosition.setColumn(token.getCharPositionInLine() + token.getText().length());
                    if (tokenStartPosition.isBefore(this.region.getStart())) {
                        this.region.setStart(tokenStartPosition);
                    }
                    if (!tokenEndPosition.isAfter(this.region.getEnd())) continue;
                    this.region.setEnd(tokenEndPosition);
                }
            }
        }
        return this.region;
    }

    public void setToken(Token token) {
        this.token = token;
    }

    public List<AST> getDescendants() {
        if (this.descendants == null) {
            this.descendants = new ArrayList<AST>();
            this.collectDescendants(this, this.descendants, false);
        }
        return this.descendants;
    }

    protected void collectDescendants(AST ast, List<AST> descendants, boolean addAst) {
        if (addAst) {
            descendants.add(ast);
        }
        for (AST child : ast.getChildren()) {
            this.collectDescendants(child, descendants, true);
        }
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public void setImaginary(boolean imaginary) {
        this.imaginary = imaginary;
    }

    public boolean isImaginary() {
        return this.imaginary || this.getToken() == null;
    }

    public boolean areExtraTokensHidden() {
        return this.extraTokensHidden;
    }

    public void setExtraTokensHidden(boolean extraTokensHidden) {
        this.extraTokensHidden = extraTokensHidden;
    }

    public List<Token> getExtraTokens() {
        return this.extraTokens;
    }

    public void setExtraTokens(List<Token> extraTokens) {
        this.extraTokens = extraTokens;
    }

    public List<Token> getCommentTokens() {
        return this.commentTokens;
    }

    public void setCommentTokens(List<Token> comments) {
        this.commentTokens = comments;
    }

    public String toExtendedStringTreeItem() {
        return String.valueOf(this.getText()) + " " + ((Object)((Object)this)).getClass().getSimpleName() + " " + this.getRegion();
    }

    public String toExtendedStringTree() {
        return this.toExtendedStringTree(0);
    }

    public Integer getLength() {
        if (this.length == null) {
            return ((CommonToken)this.getToken()).getStopIndex() - ((CommonToken)this.getToken()).getStartIndex() + 1;
        }
        return this.length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    protected String toExtendedStringTree(int indent) {
        String toString = "";
        int i = 0;
        while (i < indent) {
            toString = String.valueOf(toString) + "  ";
            ++i;
        }
        toString = String.valueOf(toString) + this.toExtendedStringTreeItem() + "\n";
        for (AST child : this.getChildren()) {
            toString = String.valueOf(toString) + child.toExtendedStringTree(indent + 1);
        }
        return toString;
    }
}

