/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.module;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.antlr.runtime.Token;
import org.eclipse.epsilon.common.module.Comment;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.parse.Region;

public abstract class AbstractModuleElement
implements ModuleElement {
    protected ArrayList<Comment> comments = new ArrayList(0);
    protected ArrayList<ModuleElement> children = new ArrayList(3);
    protected ModuleElement parent;
    protected URI uri;
    protected IModule module;
    protected Region region = new Region();
    protected LinkedHashMap<String, Object> data = new LinkedHashMap();

    @Override
    public void build(AST cst, IModule module) {
        List<Token> commentTokens = cst.getCommentTokens();
        this.comments.ensureCapacity(commentTokens.size());
        for (Token commentToken : commentTokens) {
            Comment comment = new Comment(commentToken);
            comment.setUri(cst.getUri());
            this.comments.add(comment);
        }
    }

    @Override
    public List<Comment> getComments() {
        return this.comments;
    }

    public String getDebugInfo() {
        return "";
    }

    @Override
    public List<ModuleElement> getChildren() {
        return this.children;
    }

    @Override
    public void setUri(URI uri) {
        this.uri = uri;
    }

    @Override
    public void setModule(IModule module) {
        this.module = module;
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    @Override
    public IModule getModule() {
        return this.module;
    }

    @Override
    public File getFile() {
        if (this.uri != null && "file".equals(this.uri.getScheme())) {
            return new File(this.uri);
        }
        return null;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public void setRegion(Region region) {
        this.region = region;
    }

    @Override
    public void setParent(ModuleElement parent) {
        this.parent = parent;
        this.parent.getChildren().add(this);
    }

    @Override
    public ModuleElement getParent() {
        return this.parent;
    }

    public String toString() {
        boolean uriNotNull;
        String str = this.getClass().getSimpleName();
        boolean bl = uriNotNull = this.uri != null;
        if (uriNotNull) {
            str = String.valueOf(str) + " (" + this.uri;
        }
        if (this.region != null) {
            str = String.valueOf(str) + " @ " + this.region;
        }
        if (uriNotNull) {
            str = String.valueOf(str) + ')';
        }
        return str;
    }

    @Override
    public Map<String, Object> getData() {
        return this.data;
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.region, this.getParent());
    }

    public boolean equals(Object ame) {
        if (this == ame) {
            return true;
        }
        if (ame == null || this.getClass() != ame.getClass()) {
            return false;
        }
        AbstractModuleElement other = (AbstractModuleElement)ame;
        return Objects.equals(this.uri, other.uri) && Objects.equals(this.region, other.region);
    }
}

