/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.launch;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.epsilon.common.function.CheckedSupplier;
import org.eclipse.epsilon.common.util.OperatingSystem;
import org.eclipse.epsilon.common.util.profiling.BenchmarkUtils;
import org.eclipse.epsilon.common.util.profiling.ProfileDiagnostic;

public abstract class ProfilableRunConfiguration
implements Runnable,
Callable<Object>,
CheckedSupplier<Object, Exception> {
    protected String printMarker = "-----------------------------------------------------";
    protected int id;
    public final boolean showResults;
    public final boolean profileExecution;
    public final Path script;
    public final Path outputFile;
    protected final Collection<ProfileDiagnostic> profiledStages;
    protected boolean hasRun = false;
    protected Object result;
    protected final int targetRepeats;
    private int currentRepeat;

    public static <C extends ProfilableRunConfiguration, B extends Builder<C, B>> B Builder(Class<C> configClass) {
        Constructor<B> constructor = ProfilableRunConfiguration.findBuilder(configClass);
        if (constructor == null) {
            throw new IllegalArgumentException("Could not find suitable Builder constructor for " + configClass.getName());
        }
        try {
            constructor.setAccessible(true);
            return (B)(constructor.getParameterCount() == 0 ? (Builder)constructor.newInstance(new Object[0]) : (Builder)constructor.newInstance(configClass));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    protected static <C extends ProfilableRunConfiguration, B extends Builder<C, B>> Constructor<B> findBuilder(Class<C> configClass) {
        Objects.requireNonNull(configClass);
        Constructor constructor = null;
        Class<C> clazz = configClass;
        while (constructor == null && clazz != Object.class) {
            Collection constructors = Arrays.stream(clazz.getDeclaredClasses()).filter(c -> Modifier.isStatic(c.getModifiers())).filter(Builder.class::isAssignableFrom).flatMap(c -> Arrays.stream(c.getDeclaredConstructors())).collect(Collectors.toList());
            constructor = constructors.stream().filter(c -> Arrays.stream(c.getParameterTypes()).anyMatch(p -> p.getClass() == Class.class)).findAny().orElseGet(() -> constructors.stream().filter(c -> c.getParameterCount() == 0).findAny().orElse(null));
            clazz = configClass.getSuperclass();
        }
        return constructor;
    }

    protected ProfilableRunConfiguration(Builder<?, ?> builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Builder shouldn't be null!");
        }
        this.script = builder.script;
        this.profileExecution = builder.profileExecution;
        this.showResults = builder.showResults;
        this.outputFile = builder.outputFile;
        this.profiledStages = new ConcurrentLinkedDeque<ProfileDiagnostic>();
        this.id = Optional.ofNullable(builder.id).orElseGet(() -> Objects.hash(Objects.toString(this.script)));
        this.targetRepeats = builder.repeats;
    }

    protected ProfilableRunConfiguration(ProfilableRunConfiguration other) {
        this.script = other.script;
        this.showResults = other.showResults;
        this.profileExecution = other.profileExecution;
        this.id = other.id;
        this.outputFile = other.outputFile;
        this.result = other.result;
        this.profiledStages = other.profiledStages;
        this.targetRepeats = other.targetRepeats;
    }

    @Override
    public final Object getThrows() throws Exception {
        return this.call();
    }

    @Override
    public final Object call() throws Exception {
        this.beforeRepeatLoop();
        while (this.currentRepeat++ < this.targetRepeats) {
            if (this.currentRepeat > 1) {
                this.reset();
            }
            if (this.profileExecution) {
                System.gc();
            }
            this.preExecute();
            this.result = this.execute();
            this.hasRun = true;
            this.postExecute();
        }
        this.afterRepeatLoop();
        return this.result;
    }

    protected void beforeRepeatLoop() throws Exception {
        this.currentRepeat = 0;
    }

    protected void afterRepeatLoop() throws Exception {
        this.currentRepeat = 0;
    }

    protected final int getCurrentRepeat() {
        return this.currentRepeat;
    }

    protected final boolean isFirstRepeat() {
        return this.getCurrentRepeat() <= 1;
    }

    protected final boolean isLastRepeat() {
        return this.getCurrentRepeat() == this.targetRepeats;
    }

    @Override
    public final void run() {
        try {
            this.call();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected void handleException(Exception ex) {
        ex.printStackTrace();
    }

    protected void preExecute() throws Exception {
        Path parent;
        if (this.outputFile != null && (parent = this.outputFile.getParent()) != null) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        if (this.profileExecution) {
            this.writeOut(OperatingSystem.getOsNameAndVersion(), OperatingSystem.getJavaVersion(), BenchmarkUtils.getCpuName(), "Logical processors: " + BenchmarkUtils.getNumberOfHardwareThreads(), "Xms: " + BenchmarkUtils.getAvailableMemory(ProfileDiagnostic.MemoryUnit.MB), "Xmx: " + BenchmarkUtils.getMaxMemory(ProfileDiagnostic.MemoryUnit.MB), "Starting execution at " + BenchmarkUtils.getTime(), this.printMarker);
        }
    }

    protected abstract Object execute() throws Exception;

    protected List<Object> getProfilingOutput() {
        return Arrays.asList("Profiled processes:", BenchmarkUtils.formatExecutionStages(this.profiledStages), "Finished at " + BenchmarkUtils.getTime());
    }

    protected List<Object> getResultOutput() {
        return Arrays.asList("Result: ", this.result);
    }

    protected void postExecute() throws Exception {
        if (this.profileExecution) {
            this.writeOut(this.printMarker);
            this.writeOut(this.getProfilingOutput());
            this.writeOut(this.printMarker);
        }
        if (this.showResults) {
            this.writeOut(this.printMarker);
            this.writeOut(this.getResultOutput());
            this.writeOut(this.printMarker);
        }
    }

    protected void reset() throws Exception {
        this.profiledStages.clear();
        this.hasRun = false;
    }

    public Duration getExecutionTime() {
        if (!this.hasRun) {
            throw new IllegalStateException("Not yet run!");
        }
        return BenchmarkUtils.getTotalExecutionTimeFrom(this.profiledStages);
    }

    public Object getResult() {
        if (!this.hasRun) {
            throw new IllegalStateException("Attempted to get result without calling run()!");
        }
        return this.result;
    }

    public int getId() {
        return this.id;
    }

    public final void writeOut(Object ... lines) {
        if (lines == null || lines.length == 0) {
            return;
        }
        this.writeOut(Arrays.asList(lines));
    }

    protected void writeOut(Collection<?> lines) {
        if (lines == null || lines.isEmpty()) {
            return;
        }
        if (this.outputFile != null) {
            try {
                Files.write(this.outputFile, (Iterable<? extends CharSequence>)lines.stream().map(Objects::toString).collect(Collectors.toList()), StandardOpenOption.APPEND, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                return;
            }
            catch (IOException iox) {
                System.err.println("Couldn't write to file '" + this.outputFile + "': " + iox.getMessage());
            }
        }
        lines.forEach(System.out::println);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + ": id=" + this.id + ", script='" + Objects.toString(this.script.getFileName()) + "'";
    }

    public int hashCode() {
        return Objects.hash(this.id, this.script, this.showResults, this.profileExecution, this.outputFile);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return false;
        }
        if (!(obj instanceof ProfilableRunConfiguration)) {
            return false;
        }
        ProfilableRunConfiguration other = (ProfilableRunConfiguration)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.script, other.script) && Objects.equals(this.showResults, other.showResults) && Objects.equals(this.profileExecution, other.profileExecution) && Objects.equals(this.outputFile, other.outputFile) && Objects.equals(this.result, other.result);
    }

    public static abstract class Builder<C extends ProfilableRunConfiguration, B extends Builder<C, B>> {
        protected Class<C> configClass;
        public int repeats = 1;
        public Integer id;
        public boolean showResults;
        public boolean profileExecution;
        public Path script;
        public Path outputFile;

        protected Builder() {
            this(null);
        }

        protected Builder(Class<C> runConfigClass) {
            this.configClass = runConfigClass != null ? runConfigClass : this.getClass().getDeclaringClass();
        }

        public abstract C build() throws IllegalArgumentException, IllegalStateException;

        protected C buildReflective(Supplier<? extends C> alternative) throws IllegalStateException {
            if (Modifier.isAbstract(this.configClass.getModifiers())) {
                if (alternative == null) {
                    throw new IllegalStateException("Impossible build for class '" + this.configClass.getName() + "' and no concrete implementation!");
                }
                return (C)((ProfilableRunConfiguration)alternative.get());
            }
            try {
                return (C)((ProfilableRunConfiguration)Stream.of(this.configClass.getDeclaredConstructors()).filter(constructor -> constructor.getParameterCount() == 1 && constructor.getParameterTypes()[0].isAssignableFrom(this.getClass())).findFirst().orElseThrow(() -> new NoSuchMethodException("Couldn't find builder constructor for class '" + this.configClass.getName() + "'.")).newInstance(this));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                ex.printStackTrace();
                if (alternative != null) {
                    return (C)((ProfilableRunConfiguration)alternative.get());
                }
                throw new IllegalStateException(ex);
            }
        }

        public B with(Consumer<B> builderFunction) {
            builderFunction.accept(this);
            return (B)this;
        }

        public B withScript(Path scriptPath) {
            this.script = scriptPath;
            return (B)this;
        }

        public B withScript(String path) {
            return this.withScript(Paths.get(path, new String[0]));
        }

        public B withOutputFile(Path output) {
            this.outputFile = output;
            return (B)this;
        }

        public B withOutputFile(String path) {
            return this.withOutputFile(Paths.get(path, new String[0]));
        }

        public B withId(int id) {
            this.id = id;
            return (B)this;
        }

        public B withResults() {
            return this.showResults(true);
        }

        public B showResults() {
            return this.showResults(true);
        }

        public B showResults(boolean show) {
            this.showResults = show;
            return (B)this;
        }

        public B withRepeats(int repetition) {
            if (repetition < 1) {
                throw new IllegalArgumentException("Repeats must be positive!");
            }
            this.repeats = repetition;
            return (B)this;
        }

        public B withProfiling() {
            return this.profileExecution(true);
        }

        public B profileExecution() {
            return this.profileExecution(true);
        }

        public B profileExecution(boolean profile) {
            this.profileExecution = profile;
            return (B)this;
        }
    }
}

