/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.epsilon.common.util.CollectionUtil;

public interface BaseDelegate<T extends BaseDelegate<? extends T>> {
    public T getBase();

    public void merge(MergeMode var1);

    default public T getFrom(MergeMode mode) {
        if (mode == null) {
            return null;
        }
        return (T)(MergeMode.MERGE_INTO_BASE.equals((Object)mode) ? this : this.getBase());
    }

    default public T getTo(MergeMode mode) {
        if (mode == null) {
            return null;
        }
        return (T)(MergeMode.INHERIT_FROM_BASE.equals((Object)mode) ? this : this.getBase());
    }

    default public <C> void mergeCollectionsUnique(Function<T, Collection<C>> colPropertyGetter, Supplier<? extends Collection<C>> targetColSup, MergeMode mode) {
        if (this.getBase() != null) {
            Collection<C> from = colPropertyGetter.apply(this.getFrom(mode));
            Collection<C> to = colPropertyGetter.apply(this.getTo(mode));
            if (targetColSup == null) {
                targetColSup = ArrayList::new;
            }
            CollectionUtil.mergeCollectionsUnique(from, to, targetColSup);
        }
    }

    default public <R> R delegateLookup(Function<T, R> method) {
        R value = method.apply(this);
        if (value != null) {
            return value;
        }
        T base = this.getBase();
        if (base != null) {
            value = method.apply((BaseDelegate)base);
        }
        return value;
    }

    @SafeVarargs
    public static <T, R> R delegateLookup(Function<T, R> method, T ... instances) {
        T[] TArray = instances;
        int n = instances.length;
        int n2 = 0;
        while (n2 < n) {
            R current;
            T instance = TArray[n2];
            if (instance != null && (current = method.apply(instance)) != null) {
                return current;
            }
            ++n2;
        }
        return null;
    }

    default public <R> R delegateLookup(Function<T, R> method, boolean syncOnBase) {
        return this.delegateLookup(method, syncOnBase ? t -> t : null);
    }

    default public <R> R delegateLookup(Function<T, R> method, Function<T, ? extends Object> lockProperty) {
        T base = this.getBase();
        return BaseDelegate.delegateLookup(method, this, base, lockProperty != null && base != null ? lockProperty.apply(base) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, R> R delegateLookup(Function<T, R> method, T thisObj, T baseObj, Object lock) {
        R current = method.apply(thisObj);
        if (current != null) {
            return current;
        }
        if (baseObj != null) {
            if (lock != null) {
                Object object = lock;
                synchronized (object) {
                    return method.apply(baseObj);
                }
            }
            return method.apply(baseObj);
        }
        return null;
    }

    public static enum MergeMode {
        MERGE_INTO_BASE,
        INHERIT_FROM_BASE;

    }
}

