/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.epsilon.common.concurrent.PersistentThreadLocal;

public class ThreadLocalBatchData<D>
extends PersistentThreadLocal<List<D>> {
    public ThreadLocalBatchData() {
        this(0);
    }

    public ThreadLocalBatchData(int numThreads) {
        super(numThreads, ArrayList::new);
    }

    public static <K, V> ThreadLocalBatchData<Map.Entry<? extends K, ? extends V>> ofEntry() {
        return new ThreadLocalBatchData<Map.Entry<? extends K, ? extends V>>();
    }

    public static <K, V> ThreadLocalBatchData<Map.Entry<? extends K, ? extends V>> ofEntry(int parallelism) {
        return new ThreadLocalBatchData<Map.Entry<? extends K, ? extends V>>(parallelism);
    }

    public static ThreadLocalBatchData<?> ofAny(int parallelism) {
        return new ThreadLocalBatchData(parallelism);
    }

    public static ThreadLocalBatchData<?> ofAny() {
        return new ThreadLocalBatchData();
    }

    public Collection<D> getBatch() {
        return this.getAll().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public void addElement(D value) {
        this.getAndThen(data -> {
            boolean bl = data.add(value);
        });
    }

    public void removeElement(D value) {
        this.getAndThen(data -> {
            boolean bl = data.remove(value);
        });
    }

    public void updateElement(D oldValue, D newValue) {
        this.getAndThen(data -> data.replaceAll(value -> Objects.equals(value, oldValue) ? newValue : value));
    }

    protected void getAndThen(Consumer<List<D>> dataConsumer) {
        List data = (List)this.get();
        if (data != null) {
            dataConsumer.accept(data);
        }
    }
}

