/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.concurrent;

import java.util.function.Supplier;
import org.eclipse.epsilon.common.concurrent.ConcurrentExecutionStatus;

public class SingleConcurrentExecutionStatus
extends ConcurrentExecutionStatus {
    protected long waitTimeout = 0L;
    private volatile boolean inProgress = false;
    private Object result;
    private Object currentLock;

    @Override
    protected final Object getResult(Object lockObj) {
        return this.result;
    }

    @Override
    protected final boolean register(Object lockObj) {
        if (!this.inProgress) {
            this.exception = null;
            this.result = null;
            this.inProgress = true;
            return true;
        }
        return false;
    }

    @Override
    protected final boolean isInProgress(Object lockObj) {
        return this.inProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void completeSuccessfully(Object lockObj) {
        this.inProgress = false;
        if (lockObj != null) {
            Object object = lockObj;
            synchronized (object) {
                lockObj.notifyAll();
            }
        }
        if (this.currentLock != lockObj) {
            Object object = this.currentLock;
            synchronized (object) {
                this.currentLock.notifyAll();
            }
        }
        this.currentLock = null;
    }

    @Override
    protected final void completeWithResult(Object lockObj, Object result) {
        this.result = result;
        this.completeSuccessfully(lockObj);
    }

    @Override
    public final void completeExceptionally(Throwable exception) {
        this.completeExceptionallyBase(exception);
        this.completeSuccessfully(this.currentLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected final boolean waitForCompletion(Object lockObj, Supplier<Boolean> targetState) {
        assert (lockObj != null);
        this.currentLock = lockObj;
        Object object = lockObj;
        synchronized (object) {
            while (this.inProgress && (targetState == null || !targetState.get().booleanValue())) {
                try {
                    lockObj.wait(this.waitTimeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.currentLock = null;
        return this.exception == null;
    }

    @Override
    public Throwable waitForExceptionalCompletion() {
        this.waitForCompletion(() -> this.exception != null);
        return this.exception;
    }
}

