/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.concurrent;

import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.epsilon.common.concurrent.ConcurrencyUtils;

public class PersistentThreadLocal<T>
extends ThreadLocal<T> {
    protected final Map<Thread, T> allValues;
    protected final Supplier<? extends T> valueGetter;

    public PersistentThreadLocal(Supplier<? extends T> initialValue) {
        this(0, initialValue);
    }

    public PersistentThreadLocal(int numThreads, Supplier<? extends T> initialValue) {
        numThreads = numThreads > 0 ? numThreads : ConcurrencyUtils.DEFAULT_PARALLELISM;
        this.allValues = ConcurrencyUtils.concurrentMap(numThreads, numThreads);
        this.valueGetter = initialValue;
    }

    @Override
    protected T initialValue() {
        Object value = this.valueGetter != null ? this.valueGetter.get() : super.initialValue();
        this.allValues.put(Thread.currentThread(), value);
        return value;
    }

    @Override
    public void set(T value) {
        super.set(value);
        this.allValues.put(Thread.currentThread(), value);
    }

    @Override
    public void remove() {
        super.remove();
        this.allValues.remove(Thread.currentThread());
    }

    public Collection<T> getAll() {
        return this.allValues.values();
    }

    public int size() {
        return this.allValues.size();
    }

    public void removeAll() {
        this.allValues.clear();
        this.remove();
    }
}

