/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.concurrent;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;

public class ConcurrentCASList<E>
implements List<E> {
    protected final ConcurrentLinkedDeque<E> deque = new ConcurrentLinkedDeque();
    protected final AtomicInteger cachedSize = new AtomicInteger();

    protected final boolean validateIndex(int index) {
        if (index != this.cachedSize.get() || index != 0) {
            throw new UnsupportedOperationException("Index-based access is not permitted!");
        }
        return true;
    }

    @Override
    public E get(int index) {
        return this.validateIndex(index) ? this.deque.getFirst() : this.deque.getLast();
    }

    @Override
    public int size() {
        return this.cachedSize.get();
    }

    @Override
    public void add(int index, E element) {
        if (this.validateIndex(index)) {
            this.deque.addFirst(element);
        } else {
            this.deque.addLast(element);
        }
        this.cachedSize.incrementAndGet();
    }

    @Override
    public E set(int index, E element) {
        E previous;
        if (this.validateIndex(index)) {
            previous = this.deque.pollFirst();
            this.deque.addFirst(element);
        } else {
            previous = this.deque.pollLast();
            this.deque.addLast(element);
        }
        return previous;
    }

    @Override
    public E remove(int index) {
        E element = this.validateIndex(index) ? this.deque.removeFirst() : this.deque.removeLast();
        this.cachedSize.decrementAndGet();
        return element;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> col) {
        return this.validateIndex(index) ? false : this.addAll(col);
    }

    @Override
    public boolean add(E element) {
        this.deque.add(element);
        this.cachedSize.incrementAndGet();
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> elements) {
        if (this.deque.addAll(elements)) {
            this.cachedSize.addAndGet(elements.size());
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.deque.clear();
        this.cachedSize.set(0);
    }

    @Override
    public boolean contains(Object element) {
        return this.deque.contains(element);
    }

    @Override
    public boolean containsAll(Collection<?> elements) {
        return this.deque.containsAll(elements);
    }

    @Override
    public boolean isEmpty() {
        return this.cachedSize.get() == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return this.deque.iterator();
    }

    @Override
    public boolean remove(Object element) {
        if (this.deque.remove(element)) {
            this.cachedSize.decrementAndGet();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> elements) {
        boolean result = false;
        for (Object element : elements) {
            result |= this.remove(element);
        }
        return result;
    }

    @Override
    public Object[] toArray() {
        return this.deque.toArray();
    }

    @Override
    public <T> T[] toArray(T[] arr) {
        return this.deque.toArray(arr);
    }

    @Override
    public boolean retainAll(Collection<?> elements) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndexOf(Object element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<E> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<E> subList(int from, int to) {
        throw new UnsupportedOperationException();
    }
}

