/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.concurrent;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.eclipse.epsilon.common.util.SizeCachingConcurrentQueue;

public class ConcurrencyUtils {
    public static final Thread TOP_LEVEL_THREAD = Thread.currentThread();
    public static final int DEFAULT_PARALLELISM = Runtime.getRuntime().availableProcessors();
    private static final int DEFAULT_CAPACITY = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.7f;

    public static final boolean isMainThread() {
        return Thread.currentThread().getName().equals("main");
    }

    public static final boolean isTopLevelThread() {
        return Thread.currentThread() == TOP_LEVEL_THREAD;
    }

    public static final <T> Collection<T> concurrentOrderedCollection() {
        return ConcurrencyUtils.concurrentOrderedCollection(null);
    }

    public static <T> Collection<T> concurrentOrderedCollection(Collection<? extends T> values) {
        return values != null ? new SizeCachingConcurrentQueue<T>(values) : new SizeCachingConcurrentQueue();
    }

    public static <T> Set<T> concurrentSet() {
        return ConcurrencyUtils.concurrentSet(-1, -1);
    }

    public static <T> Set<T> concurrentSet(Collection<T> initial) {
        ConcurrentHashMap.KeySetView cs = ConcurrencyUtils.newConcurrentHashMap(null, initial != null ? initial.size() : -1, -1).keySet(Boolean.TRUE);
        if (cs != null) {
            cs.addAll(initial);
        }
        return cs;
    }

    public static <T> Set<T> concurrentSet(int initialCapacity, int parallelism) {
        return ConcurrencyUtils.newConcurrentHashMap(null, initialCapacity, parallelism).keySet(Boolean.TRUE);
    }

    public static <K, V> ConcurrentMap<K, V> concurrentMap() {
        return ConcurrencyUtils.newConcurrentHashMap(null, -1, -1);
    }

    public static <K, V> ConcurrentMap<K, V> concurrentMap(Map<? extends K, ? extends V> initial) {
        return ConcurrencyUtils.newConcurrentHashMap(initial, -1, -1);
    }

    public static <K, V> ConcurrentMap<K, V> concurrentMap(int initialCapacity, int parallelism) {
        return ConcurrencyUtils.newConcurrentHashMap(null, initialCapacity, parallelism);
    }

    private static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(Map<? extends K, ? extends V> initial, int initialCapacity, int parallelism) {
        if (initial != null) {
            return new ConcurrentHashMap<K, V>(initial);
        }
        return new ConcurrentHashMap(initialCapacity >= 0 ? initialCapacity : 16, 0.7f, parallelism > 0 ? parallelism : 1 + DEFAULT_PARALLELISM / 2);
    }

    public static void executeAsync(Runnable r1, Runnable r2) throws InterruptedException, ExecutionException {
        ((CompletableFuture)CompletableFuture.runAsync(r1).thenCombine(CompletableFuture.runAsync(r2), (v1, v2) -> null)).get();
    }

    public static Collection<Callable<?>> runnableToCallable(Collection<? extends Runnable> runnables) {
        ArrayDeque callables = new ArrayDeque(runnables.size());
        for (Runnable runnable : runnables) {
            callables.add(ConcurrencyUtils.runnableToCallable(runnable));
        }
        return callables;
    }

    public static Callable<?> runnableToCallable(Runnable runnable) {
        return () -> {
            runnable.run();
            return null;
        };
    }
}

