/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.BitSet;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Local;
import soot.Singletons;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.options.Options;
import soot.util.Chain;

public class UnusedLocalEliminator
extends BodyTransformer {
    private static final Logger logger = LoggerFactory.getLogger(UnusedLocalEliminator.class);

    public UnusedLocalEliminator(Singletons.Global g) {
    }

    public static UnusedLocalEliminator v() {
        return G.v().soot_toolkits_scalar_UnusedLocalEliminator();
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map<String, String> options) {
        if (Options.v().verbose()) {
            logger.debug("[" + body.getMethod().getName() + "] Eliminating unused locals...");
        }
        Chain<Local> locals = body.getLocals();
        int numLocals = locals.size();
        int[] oldNumbers = new int[numLocals];
        int i = 0;
        for (Local local : locals) {
            oldNumbers[i] = local.getNumber();
            local.setNumber(i);
            ++i;
        }
        BitSet usedLocals = new BitSet(numLocals);
        for (Unit s : body.getUnits()) {
            Local l;
            Value v;
            for (ValueBox vb : s.getUseBoxes()) {
                v = vb.getValue();
                if (!(v instanceof Local)) continue;
                l = (Local)v;
                usedLocals.set(l.getNumber());
            }
            for (ValueBox vb : s.getDefBoxes()) {
                v = vb.getValue();
                if (!(v instanceof Local)) continue;
                l = (Local)v;
                usedLocals.set(l.getNumber());
            }
        }
        Iterator<Local> localIt = locals.iterator();
        while (localIt.hasNext()) {
            Local local;
            local = localIt.next();
            int lno = local.getNumber();
            if (!usedLocals.get(lno)) {
                localIt.remove();
                continue;
            }
            local.setNumber(oldNumbers[lno]);
        }
    }
}

