/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Local;
import soot.Scene;
import soot.Singletons;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.dexpler.DexNullArrayRefTransformer;
import soot.dexpler.DexNullThrowTransformer;
import soot.jimple.AssignStmt;
import soot.jimple.CmpgExpr;
import soot.jimple.CmplExpr;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.DoubleConstant;
import soot.jimple.FloatConstant;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.IntConstant;
import soot.jimple.LongConstant;
import soot.jimple.RealConstant;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;
import soot.jimple.internal.ImmediateBox;
import soot.jimple.toolkits.scalar.CopyPropagator;
import soot.options.Options;
import soot.tagkit.Tag;
import soot.toolkits.exceptions.ThrowAnalysis;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.ExceptionalUnitGraphFactory;
import soot.toolkits.scalar.ForwardFlowAnalysis;
import soot.util.LocalBitSetPacker;

public class FlowSensitiveConstantPropagator
extends BodyTransformer {
    private static final Logger logger = LoggerFactory.getLogger(FlowSensitiveConstantPropagator.class);
    protected ThrowAnalysis throwAnalysis;
    protected boolean omitExceptingUnitEdges;

    public FlowSensitiveConstantPropagator(Singletons.Global g) {
    }

    public FlowSensitiveConstantPropagator(ThrowAnalysis ta) {
        this(ta, false);
    }

    public FlowSensitiveConstantPropagator(ThrowAnalysis ta, boolean omitExceptingUnitEdges) {
        this.throwAnalysis = ta;
        this.omitExceptingUnitEdges = omitExceptingUnitEdges;
    }

    public static FlowSensitiveConstantPropagator v() {
        return G.v().soot_toolkits_scalar_FlowSensitiveConstantPropagator();
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map<String, String> options) {
        if (Options.v().verbose()) {
            logger.debug("[" + body.getMethod().getName() + "] Splitting for shared initialization of locals...");
        }
        if (this.throwAnalysis == null) {
            this.throwAnalysis = Scene.v().getDefaultThrowAnalysis();
        }
        if (!this.omitExceptingUnitEdges) {
            this.omitExceptingUnitEdges = Options.v().omit_excepting_unit_edges();
        }
        LocalBitSetPacker localPacker = new LocalBitSetPacker(body);
        localPacker.pack();
        ExceptionalUnitGraph graph = ExceptionalUnitGraphFactory.createExceptionalUnitGraph(body, this.throwAnalysis, this.omitExceptingUnitEdges);
        BetterConstantPropagator bcp = this.createBetterConstantPropagator(graph);
        bcp.doAnalysis();
        boolean propagatedThrow = false;
        for (Unit u : body.getUnits()) {
            ConstantState v = (ConstantState)bcp.getFlowBefore(u);
            boolean expectsRealValue = false;
            if (u instanceof AssignStmt) {
                Local l;
                Constant c;
                AssignStmt assign = (AssignStmt)u;
                Value rop = assign.getRightOp();
                if (rop instanceof Local && (c = v.getConstant(l = (Local)rop)) != null) {
                    List<Tag> oldTags = assign.getRightOpBox().getTags();
                    assign.setRightOp(c);
                    assign.getRightOpBox().getTags().addAll(oldTags);
                    CopyPropagator.copyLineTags(assign.getUseBoxes().get(0), assign);
                    continue;
                }
                expectsRealValue = FlowSensitiveConstantPropagator.expectsRealValue(rop);
            }
            if (u instanceof IfStmt) {
                expectsRealValue = FlowSensitiveConstantPropagator.expectsRealValue(((IfStmt)u).getCondition());
            }
            for (ValueBox r : u.getUseBoxes()) {
                Constant val;
                Value src;
                if (!(r instanceof ImmediateBox) || !((src = r.getValue()) instanceof Local) || (val = v.getConstant((Local)src)) == null) continue;
                if (u instanceof ThrowStmt) {
                    propagatedThrow = true;
                }
                if (expectsRealValue && !(val instanceof RealConstant)) {
                    if (val instanceof IntConstant) {
                        val = FloatConstant.v(((IntConstant)val).value);
                    } else if (val instanceof LongConstant) {
                        val = DoubleConstant.v(((LongConstant)val).value);
                    }
                }
                r.setValue(val);
            }
        }
        localPacker.unpack();
        if (propagatedThrow) {
            DexNullThrowTransformer.v().transform(body);
        }
        DexNullArrayRefTransformer.v().transform(body);
    }

    protected BetterConstantPropagator createBetterConstantPropagator(ExceptionalUnitGraph graph) {
        return new BetterConstantPropagator(graph);
    }

    private static boolean expectsRealValue(Value op) {
        return op instanceof CmpgExpr || op instanceof CmplExpr;
    }

    protected class BetterConstantPropagator
    extends ForwardFlowAnalysis<Unit, ConstantState> {
        public BetterConstantPropagator(DirectedGraph<Unit> graph) {
            super(graph);
        }

        @Override
        protected boolean omissible(Unit n) {
            if (!(n instanceof DefinitionStmt)) {
                return true;
            }
            return super.omissible(n);
        }

        @Override
        protected void flowThrough(ConstantState in, Unit d, ConstantState out) {
            in.copyTo(out);
            if (d instanceof Stmt) {
                Stmt s = (Stmt)d;
                if (s instanceof AssignStmt) {
                    AssignStmt assign = (AssignStmt)s;
                    if (assign.getLeftOp() instanceof Local) {
                        Local l = (Local)assign.getLeftOp();
                        Value rop = assign.getRightOp();
                        Constant value = null;
                        if (rop instanceof Constant) {
                            value = (Constant)rop;
                        } else if (rop instanceof Local) {
                            value = in.getConstant((Local)rop);
                        }
                        if (value == null) {
                            out.setNonConstant(l);
                        } else {
                            out.setConstant(l, value);
                        }
                    }
                } else if (s instanceof IdentityStmt) {
                    out.setNonConstant((Local)((IdentityStmt)s).getLeftOp());
                }
            }
        }

        @Override
        protected ConstantState newInitialFlow() {
            return new ConstantState();
        }

        @Override
        protected void mergeInto(Unit succNode, ConstantState inout, ConstantState in) {
            inout.mergeInto(in);
        }

        @Override
        protected void merge(ConstantState in1, ConstantState in2, ConstantState out) {
            out.merge(in1, in2);
        }

        @Override
        protected void copy(ConstantState source, ConstantState dest) {
            if (source == dest) {
                return;
            }
            source.copyTo(dest);
        }

        @Override
        protected void copyFreshToExisting(ConstantState in, ConstantState dest) {
            dest.constants = in.constants;
            dest.nonConstant = in.nonConstant;
        }
    }

    protected static class ConstantState {
        public BitSet nonConstant = new BitSet();
        public Map<Local, Constant> constants = this.createMap();

        protected ConstantState() {
        }

        protected Map<Local, Constant> createMap() {
            return new HashMap<Local, Constant>();
        }

        public Constant getConstant(Local l) {
            Constant r = this.constants.get(l);
            return r;
        }

        public void setNonConstant(Local l) {
            this.nonConstant.set(l.getNumber());
            this.constants.remove(l);
        }

        public void setConstant(Local l, Constant value) {
            if (value == null) {
                throw new IllegalArgumentException("Not valid");
            }
            this.constants.put(l, value);
            this.nonConstant.clear(l.getNumber());
        }

        public void copyTo(ConstantState dest) {
            dest.nonConstant = (BitSet)this.nonConstant.clone();
            dest.constants = new HashMap<Local, Constant>(this.constants);
        }

        private void checkConsistency() {
            for (Local i : this.constants.keySet()) {
                if (!this.nonConstant.get(i.getNumber())) continue;
                throw new IllegalStateException("A local seems to be constant and not at the same time: " + i + " (" + i.getNumber() + ")");
            }
        }

        public String toString() {
            return "Non-constants: " + this.nonConstant + "\nConstants: " + this.constants;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.constants == null ? 0 : this.constants.hashCode());
            result = 31 * result + (this.nonConstant == null ? 0 : this.nonConstant.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConstantState other = (ConstantState)obj;
            if (this.nonConstant == null ? other.nonConstant != null : !this.nonConstant.equals(other.nonConstant)) {
                return false;
            }
            return !(this.constants == null ? other.constants != null : !this.constants.equals(other.constants));
        }

        public void merge(ConstantState in1, ConstantState in2) {
            this.nonConstant.or(in1.nonConstant);
            this.nonConstant.or(in2.nonConstant);
            if (!in1.constants.isEmpty()) {
                this.mergeInternal(in1, in2);
            }
            if (!in2.constants.isEmpty()) {
                this.mergeInternal(in2, in1);
            }
        }

        private void mergeInternal(ConstantState in1, ConstantState in2) {
            for (Map.Entry<Local, Constant> r : in1.constants.entrySet()) {
                Local l = r.getKey();
                if (in2.nonConstant.get(l.getNumber())) {
                    this.setNonConstant(l);
                    continue;
                }
                Constant rr = in2.getConstant(l);
                if (rr == null) {
                    this.setConstant(l, r.getValue());
                    continue;
                }
                if (rr.equals(r.getValue())) {
                    this.setConstant(l, rr);
                    continue;
                }
                this.setNonConstant(l);
            }
        }

        public void clear() {
            this.nonConstant.clear();
            this.constants = this.createMap();
        }

        public void mergeInto(ConstantState in) {
            this.nonConstant.or(in.nonConstant);
            if (!in.constants.isEmpty()) {
                this.mergeInternal(in, this);
            }
            Iterator<Local> it = this.constants.keySet().iterator();
            while (it.hasNext()) {
                if (!in.nonConstant.get(it.next().getNumber())) continue;
                it.remove();
            }
        }
    }
}

