/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.Local;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.options.Options;
import soot.toolkits.exceptions.PedanticThrowAnalysis;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.ExceptionalUnitGraphFactory;
import soot.toolkits.scalar.LiveLocals;
import soot.toolkits.scalar.SimpleLiveLocals;
import soot.util.ArraySet;

public class FastColorer {
    private FastColorer() {
    }

    public static <G> void unsplitAssignColorsToLocals(Body unitBody, Map<Local, G> localToGroup, Map<Local, Integer> localToColor, Map<G, Integer> groupToColorCount) {
        ExceptionalUnitGraph unitGraph = ExceptionalUnitGraphFactory.createExceptionalUnitGraph(unitBody, PedanticThrowAnalysis.v(), Options.v().omit_excepting_unit_edges());
        UnitInterferenceGraph intGraph = new UnitInterferenceGraph(unitBody, localToGroup, new SimpleLiveLocals(unitGraph), unitGraph);
        HashMap<Local, String> localToOriginalName = new HashMap<Local, String>();
        for (Local local : intGraph.getLocals()) {
            String name = local.getName();
            int signIndex = name.indexOf(35);
            if (signIndex >= 0) {
                name = name.substring(0, signIndex);
            }
            localToOriginalName.put(local, name);
        }
        HashMap originalNameAndGroupToColors = new HashMap();
        int[] freeColors = new int[10];
        for (Local local : intGraph.getLocals()) {
            StringGroupPair key;
            ArrayList<Integer> originalNameColors;
            if (localToColor.containsKey(local)) continue;
            G group = localToGroup.get(local);
            int colorCount = groupToColorCount.get(group);
            if (freeColors.length < colorCount) {
                freeColors = new int[Math.max(freeColors.length * 2, colorCount)];
            }
            Arrays.fill(freeColors, 0, colorCount, 1);
            Local[] interferences = intGraph.getInterferencesOf(local);
            if (interferences != null) {
                for (Local element : interferences) {
                    if (!localToColor.containsKey(element)) continue;
                    int usedColor = localToColor.get(element);
                    freeColors[usedColor] = 0;
                }
            }
            if ((originalNameColors = (ArrayList<Integer>)originalNameAndGroupToColors.get(key = new StringGroupPair((String)localToOriginalName.get(local), group))) == null) {
                originalNameColors = new ArrayList<Integer>();
                originalNameAndGroupToColors.put(key, originalNameColors);
            }
            boolean found = false;
            Integer assignedColor = 0;
            for (Integer color : originalNameColors) {
                if (freeColors[color] != 1) continue;
                found = true;
                assignedColor = color;
            }
            if (!found) {
                assignedColor = colorCount++;
                groupToColorCount.put(group, colorCount);
                originalNameColors.add(assignedColor);
            }
            localToColor.put(local, assignedColor);
        }
    }

    public static <G> void assignColorsToLocals(Body unitBody, Map<Local, G> localToGroup, Map<Local, Integer> localToColor, Map<G, Integer> groupToColorCount) {
        ExceptionalUnitGraph unitGraph = ExceptionalUnitGraphFactory.createExceptionalUnitGraph(unitBody, PedanticThrowAnalysis.v(), Options.v().omit_excepting_unit_edges());
        final UnitInterferenceGraph intGraph = new UnitInterferenceGraph(unitBody, localToGroup, new SimpleLiveLocals(unitGraph), unitGraph);
        ArrayList<Local> sortedLocals = new ArrayList<Local>(intGraph.getLocals());
        Collections.sort(sortedLocals, new Comparator<Local>(){

            @Override
            public int compare(Local o1, Local o2) {
                return intGraph.getInterferenceCount(o2) - intGraph.getInterferenceCount(o1);
            }
        });
        for (Local local : sortedLocals) {
            if (localToColor.containsKey(local)) continue;
            G group = localToGroup.get(local);
            int colorCount = groupToColorCount.get(group);
            BitSet blockedColors = new BitSet(colorCount);
            Local[] interferences = intGraph.getInterferencesOf(local);
            if (interferences != null) {
                for (Local element : interferences) {
                    if (!localToColor.containsKey(element)) continue;
                    blockedColors.set(localToColor.get(element));
                }
            }
            int assignedColor = -1;
            for (int i = 0; i < colorCount; ++i) {
                if (blockedColors.get(i)) continue;
                assignedColor = i;
                break;
            }
            if (assignedColor < 0) {
                assignedColor = colorCount++;
                groupToColorCount.put(group, colorCount);
            }
            localToColor.put(local, assignedColor);
        }
    }

    private static class StringGroupPair {
        private final String string;
        private final Object group;

        public StringGroupPair(String s, Object g) {
            this.string = s;
            this.group = g;
        }

        public boolean equals(Object p) {
            if (p instanceof StringGroupPair) {
                StringGroupPair temp = (StringGroupPair)p;
                return this.string.equals(temp.string) && this.group.equals(temp.group);
            }
            return false;
        }

        public int hashCode() {
            return this.string.hashCode() * 101 + this.group.hashCode() + 17;
        }
    }

    private static class UnitInterferenceGraph {
        final Map<Local, Set<Local>> localToLocals;
        final List<Local> locals;

        public UnitInterferenceGraph(Body body, Map<Local, ? extends Object> localToGroup, LiveLocals liveLocals, ExceptionalUnitGraph unitGraph) {
            this.locals = new ArrayList<Local>(body.getLocals());
            this.localToLocals = new HashMap<Local, Set<Local>>(body.getLocalCount() * 2 + 1, 0.7f);
            for (Unit unit : body.getUnits()) {
                List<ValueBox> defBoxes = unit.getDefBoxes();
                if (defBoxes.isEmpty()) continue;
                if (defBoxes.size() != 1) {
                    throw new RuntimeException("invalid number of def boxes");
                }
                Value defValue = defBoxes.get(0).getValue();
                if (!(defValue instanceof Local)) continue;
                Local defLocal = (Local)defValue;
                HashSet<Local> liveLocalsAtUnit = new HashSet<Local>();
                for (Unit succ : unitGraph.getSuccsOf(unit)) {
                    liveLocalsAtUnit.addAll(liveLocals.getLiveLocalsBefore(succ));
                }
                for (Local otherLocal : liveLocalsAtUnit) {
                    if (!localToGroup.get(otherLocal).equals(localToGroup.get(defLocal))) continue;
                    this.setInterference(defLocal, otherLocal);
                }
            }
        }

        public List<Local> getLocals() {
            return this.locals;
        }

        public void setInterference(Local l1, Local l2) {
            Set<Local> locals = this.localToLocals.get(l1);
            if (locals == null) {
                locals = new ArraySet<Local>();
                this.localToLocals.put(l1, locals);
            }
            locals.add(l2);
            locals = this.localToLocals.get(l2);
            if (locals == null) {
                locals = new ArraySet<Local>();
                this.localToLocals.put(l2, locals);
            }
            locals.add(l1);
        }

        public int getInterferenceCount(Local l) {
            Set<Local> localSet = this.localToLocals.get(l);
            return localSet == null ? 0 : localSet.size();
        }

        public Local[] getInterferencesOf(Local l) {
            Set<Local> localSet = this.localToLocals.get(l);
            if (localSet == null) {
                return null;
            }
            return localSet.toArray(new Local[localSet.size()]);
        }
    }
}

