/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.DominatorsFinder;

public class MHGDominatorsFinder<N>
implements DominatorsFinder<N> {
    protected final DirectedGraph<N> graph;
    protected final Set<N> heads;
    protected final Map<N, BitSet> nodeToFlowSet;
    protected final Map<N, Integer> nodeToIndex;
    protected final Map<Integer, N> indexToNode;
    protected int lastIndex = 0;

    public MHGDominatorsFinder(DirectedGraph<N> graph) {
        this.graph = graph;
        this.heads = new HashSet<N>(graph.getHeads());
        int size = graph.size() * 2 + 1;
        this.nodeToFlowSet = new HashMap<N, BitSet>(size, 0.7f);
        this.nodeToIndex = new HashMap<N, Integer>(size, 0.7f);
        this.indexToNode = new HashMap<Integer, N>(size, 0.7f);
        this.doAnalysis();
    }

    protected void doAnalysis() {
        boolean changed;
        DirectedGraph<N> graph = this.graph;
        BitSet fullSet = new BitSet(graph.size());
        fullSet.flip(0, graph.size());
        for (N o : graph) {
            if (this.heads.contains(o)) {
                BitSet self = new BitSet();
                self.set(this.indexOf(o));
                this.nodeToFlowSet.put(o, self);
                continue;
            }
            this.nodeToFlowSet.put(o, fullSet);
        }
        do {
            changed = false;
            for (N o : graph) {
                if (this.heads.contains(o)) continue;
                BitSet predsIntersect = (BitSet)fullSet.clone();
                for (N next : graph.getPredsOf(o)) {
                    predsIntersect.and(this.getDominatorsBitSet(next));
                }
                BitSet oldSet = this.getDominatorsBitSet(o);
                predsIntersect.set(this.indexOf(o));
                if (predsIntersect.equals(oldSet)) continue;
                this.nodeToFlowSet.put(o, predsIntersect);
                changed = true;
            }
        } while (changed);
    }

    protected BitSet getDominatorsBitSet(N node) {
        BitSet bitSet = this.nodeToFlowSet.get(node);
        assert (bitSet != null) : "Node " + node + " is not in the graph!";
        return bitSet;
    }

    protected int indexOfAssert(N o) {
        Integer index = this.nodeToIndex.get(o);
        assert (index != null) : "Node " + o + " is not in the graph!";
        return index;
    }

    protected int indexOf(N o) {
        Integer index = this.nodeToIndex.get(o);
        if (index == null) {
            index = this.lastIndex;
            this.nodeToIndex.put(o, index);
            this.indexToNode.put(index, o);
            ++this.lastIndex;
        }
        return index;
    }

    @Override
    public DirectedGraph<N> getGraph() {
        return this.graph;
    }

    @Override
    public List<N> getDominators(N node) {
        ArrayList<N> result = new ArrayList<N>();
        BitSet bitSet = this.getDominatorsBitSet(node);
        int i = bitSet.nextSetBit(0);
        while (i >= 0) {
            result.add(this.indexToNode.get(i));
            if (i == Integer.MAX_VALUE) break;
            i = bitSet.nextSetBit(i + 1);
        }
        return result;
    }

    @Override
    public N getImmediateDominator(N node) {
        if (this.heads.contains(node)) {
            return null;
        }
        BitSet doms = (BitSet)this.getDominatorsBitSet(node).clone();
        doms.clear(this.indexOfAssert(node));
        int i = doms.nextSetBit(0);
        while (i >= 0) {
            N dominator = this.indexToNode.get(i);
            if (this.isDominatedByAll(dominator, doms) && dominator != null) {
                return dominator;
            }
            if (i == Integer.MAX_VALUE) break;
            i = doms.nextSetBit(i + 1);
        }
        return null;
    }

    private boolean isDominatedByAll(N node, BitSet doms) {
        BitSet s1 = this.getDominatorsBitSet(node);
        int i = doms.nextSetBit(0);
        while (i >= 0) {
            if (!s1.get(i)) {
                return false;
            }
            if (i == Integer.MAX_VALUE) break;
            i = doms.nextSetBit(i + 1);
        }
        return true;
    }

    @Override
    public boolean isDominatedBy(N node, N dominator) {
        return this.getDominatorsBitSet(node).get(this.indexOfAssert(dominator));
    }

    @Override
    public boolean isDominatedByAll(N node, Collection<N> dominators) {
        BitSet s1 = this.getDominatorsBitSet(node);
        for (N n : dominators) {
            if (s1.get(this.indexOfAssert(n))) continue;
            return false;
        }
        return true;
    }
}

