/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.toolkits.graph.MutableDirectedGraph;

public class HashMutableDirectedGraph<N>
implements MutableDirectedGraph<N> {
    private static final Logger logger = LoggerFactory.getLogger(HashMutableDirectedGraph.class);
    protected final Map<N, Set<N>> nodeToPreds;
    protected final Map<N, Set<N>> nodeToSuccs;
    protected final Set<N> heads;
    protected final Set<N> tails;

    private static <T> List<T> getCopy(Collection<? extends T> c) {
        return Collections.unmodifiableList(new ArrayList<T>(c));
    }

    private static <A, B> Map<A, Set<B>> deepCopy(Map<A, Set<B>> in) {
        HashMap<A, Set<B>> retVal = new HashMap<A, Set<B>>(in);
        for (Map.Entry<A, Set<B>> e : retVal.entrySet()) {
            e.setValue(new LinkedHashSet(e.getValue()));
        }
        return retVal;
    }

    public HashMutableDirectedGraph() {
        this.nodeToPreds = new HashMap<N, Set<N>>();
        this.nodeToSuccs = new HashMap<N, Set<N>>();
        this.heads = new HashSet<N>();
        this.tails = new HashSet<N>();
    }

    public HashMutableDirectedGraph(HashMutableDirectedGraph<N> orig) {
        this.nodeToPreds = HashMutableDirectedGraph.deepCopy(orig.nodeToPreds);
        this.nodeToSuccs = HashMutableDirectedGraph.deepCopy(orig.nodeToSuccs);
        this.heads = new HashSet<N>(orig.heads);
        this.tails = new HashSet<N>(orig.tails);
    }

    public Object clone() {
        return new HashMutableDirectedGraph<N>(this);
    }

    public void clearAll() {
        this.nodeToPreds.clear();
        this.nodeToSuccs.clear();
        this.heads.clear();
        this.tails.clear();
    }

    @Override
    public List<N> getHeads() {
        return HashMutableDirectedGraph.getCopy(this.heads);
    }

    @Override
    public List<N> getTails() {
        return HashMutableDirectedGraph.getCopy(this.tails);
    }

    @Override
    public List<N> getPredsOf(N s) {
        Set<N> preds = this.nodeToPreds.get(s);
        if (preds != null) {
            return HashMutableDirectedGraph.getCopy(preds);
        }
        throw new RuntimeException(s + " not in graph!");
    }

    public Set<N> getPredsOfAsSet(N s) {
        Set<N> preds = this.nodeToPreds.get(s);
        if (preds != null) {
            return Collections.unmodifiableSet(preds);
        }
        throw new RuntimeException(s + " not in graph!");
    }

    @Override
    public List<N> getSuccsOf(N s) {
        Set<N> succs = this.nodeToSuccs.get(s);
        if (succs != null) {
            return HashMutableDirectedGraph.getCopy(succs);
        }
        throw new RuntimeException(s + " not in graph!");
    }

    public Set<N> getSuccsOfAsSet(N s) {
        Set<N> succs = this.nodeToSuccs.get(s);
        if (succs != null) {
            return Collections.unmodifiableSet(succs);
        }
        throw new RuntimeException(s + " not in graph!");
    }

    @Override
    public int size() {
        return this.nodeToPreds.keySet().size();
    }

    @Override
    public Iterator<N> iterator() {
        return this.nodeToPreds.keySet().iterator();
    }

    @Override
    public void addEdge(N from, N to) {
        if (from == null || to == null) {
            throw new RuntimeException("edge with null endpoint");
        }
        if (this.containsEdge(from, to)) {
            return;
        }
        Set<N> succsList = this.nodeToSuccs.get(from);
        if (succsList == null) {
            throw new RuntimeException(from + " not in graph!");
        }
        Set<N> predsList = this.nodeToPreds.get(to);
        if (predsList == null) {
            throw new RuntimeException(to + " not in graph!");
        }
        this.heads.remove(to);
        this.tails.remove(from);
        succsList.add(to);
        predsList.add(from);
    }

    @Override
    public void removeEdge(N from, N to) {
        Set<N> succs = this.nodeToSuccs.get(from);
        if (succs == null || !succs.contains(to)) {
            return;
        }
        Set<N> preds = this.nodeToPreds.get(to);
        if (preds == null) {
            throw new RuntimeException(to + " not in graph!");
        }
        succs.remove(to);
        preds.remove(from);
        if (succs.isEmpty()) {
            this.tails.add(from);
        }
        if (preds.isEmpty()) {
            this.heads.add(to);
        }
    }

    @Override
    public boolean containsEdge(N from, N to) {
        Set<N> succs = this.nodeToSuccs.get(from);
        return succs != null && succs.contains(to);
    }

    @Override
    public boolean containsNode(N node) {
        return this.nodeToPreds.keySet().contains(node);
    }

    @Override
    public List<N> getNodes() {
        return HashMutableDirectedGraph.getCopy(this.nodeToPreds.keySet());
    }

    @Override
    public void addNode(N node) {
        if (this.containsNode(node)) {
            throw new RuntimeException("Node already in graph");
        }
        this.nodeToSuccs.put(node, new LinkedHashSet());
        this.nodeToPreds.put(node, new LinkedHashSet());
        this.heads.add(node);
        this.tails.add(node);
    }

    @Override
    public void removeNode(N node) {
        for (Object n : new ArrayList(this.nodeToSuccs.get(node))) {
            this.removeEdge(node, n);
        }
        this.nodeToSuccs.remove(node);
        for (Object n : new ArrayList(this.nodeToPreds.get(node))) {
            this.removeEdge(n, node);
        }
        this.nodeToPreds.remove(node);
        this.heads.remove(node);
        this.tails.remove(node);
    }

    public void printGraph() {
        for (N node : this) {
            logger.debug("Node = " + node);
            logger.debug("Preds:");
            for (N p : this.getPredsOf(node)) {
                logger.debug("     ");
                logger.debug("" + p);
            }
            logger.debug("Succs:");
            for (N s : this.getSuccsOf(node)) {
                logger.debug("     ");
                logger.debug("" + s);
            }
        }
    }
}

